<?php
/**
 * Background Mask Style - Chevrons.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Chevrons
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Chevrons extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Chevrons', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M856.08,720,565.7,1440H0V0H565.7ZM1006.14,0H816.2l290.38,720-1.51,3.74L816.2,1440h189.94l290.39-720ZM1190.7,0H1081.62L1372,720l-290.39,720H1190.7l290.38-720ZM794.63,0H568.2L858.58,720l-.17.43L568.2,1440H794.63L1085,720Zm610.79,0H1374l290.39,720L1374,1440h31.42l290.39-720Z"/>',
					'portrait'  => '<path d="M1335,1280,818.72,2560H416.17L932.1,1280.77l.3-.77L416.17,0H818.72ZM411.73,0H0V2560H411.73L928,1280ZM1920,984.77,1522.83,0H1328.92l516.24,1280L1328.92,2560h193.91L1920,1575.23ZM1194.74,0H857.06L1373.3,1280l-2.69,6.65L857.06,2560h337.68L1711,1280Z"/>',
					'square'    => '<path d="M692.18,960,305,1920H0V0H305ZM892.25,0H639l387.17,960-2,5L639,1920H892.26l387.17-960Zm246.08,0H992.89l387.18,960L992.89,1920h145.44l387.18-960ZM610.24,0H308.33L695.51,960l-.24.58L308.33,1920H610.24L997.42,960Zm814.39,0h-41.9l387.18,960-387.18,960h41.9l387.18-960Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path d="M1664.39,720,1374,1440H1190.7l290.38-720L1190.7,0H1374Zm-805.81,0L568.2,0h-2.5L856.08,720,565.7,1440h2.5L858.41,720.43Zm223-720h-75.48l290.39,720-290.39,720h75.48L1372,720Zm25,720L816.2,0H794.63L1085,720,794.63,1440H816.2l288.87-716.26Zm589.23,0-290.39,720H1920V0H1405.42Z"/>',
					'portrait'  => '<path d="M1845.16,1280,1328.92,2560H1194.74L1711,1280,1194.74,0h134.18Zm-912.76,0L416.17,0h-4.44L928,1280,411.73,2560h4.44L932.1,1280.77ZM1522.83,0,1920,984.77V0ZM1373.3,1280,857.06,0H818.72L1335,1280,818.72,2560h38.34l513.55-1273.35ZM1920,2560V1575.23L1522.83,2560Z"/>',
					'square'    => '<path d="M1024.16,965,639,1920H610.24L997.42,960,610.24,0H639l387.17,960ZM992.89,0H892.25l387.18,960L892.26,1920H992.89l387.18-960Zm389.84,0h-244.4l387.18,960-387.18,960h244.4l387.18-960Zm429.08,960-387.18,960H1920V0H1424.63Zm-1116.3,0L308.33,0H305L692.18,960,305,1920h3.33L695.27,960.58Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M960,677.48l960,387.18v301.92L960.58,979.63l-.58-.23L0,1366.58V1064.66ZM0,1369.91V1440H1920v-70.09L960,982.73ZM620.55,0,0,250.28v41.89L724.43,0Zm678.9,0H1195.57L1920,292.17V250.28ZM0,536.58V682L960,294.83,1920,682V536.58L960,149.4ZM0,782.65v253.26L960,648.73l5,2,955,385.17V782.65L960,395.47Z"/>',
					'portrait'  => '<path d="M960,1493.73l960,387.18V2560H0V1880.91ZM0,1293.65v253.26l960-387.18,5,2,955,385.17V1293.65L960,906.47Zm0-246.07V1193L960,805.83,1920,1193V1047.58L960,660.4Zm0,528.08v301.92L960,1490.4l.58.23L1920,1877.58V1575.66L960,1188.48ZM0,761.28v41.89L960,416l960,387.18V761.28L960,374.1Z"/>',
					'square'    => '<path d="M960,1227.82,1920,1615v305H0V1615ZM0,1027.75V1281L960,893.83l5,2L1920,1281V1027.74L960,640.57ZM0,781.67V927.11L960,539.93l960,387.18V781.67L960,394.49Zm0,528.09v301.91l960-387.18.58.24L1920,1611.67V1309.76L960,922.58ZM0,495.37v41.9L960,150.09l960,387.18v-41.9L960,108.19Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path d="M1920,0V250.28L1299.45,0ZM960,648.73,0,1035.91v28.75L960,677.48l960,387.18v-28.75L965,650.74Zm0,330.67L0,1366.58v3.33L960,982.73l960,387.18v-3.33L960.58,979.63ZM0,682V782.65L960,395.47l960,387.18V682L960,294.83ZM724.43,0,0,292.17V536.58L960,149.4l960,387.18V292.17L1195.57,0ZM0,0V250.28L620.55,0Z"/>',
					'portrait'  => '<path d="M965,1161.74l955,385.17v28.75L960,1188.48,0,1575.66v-28.75l960-387.18Zm-5,328.66L0,1877.58v3.33l960-387.18,960,387.18v-3.33L960.58,1490.63ZM0,1193v100.64L960,906.47l960,387.18V1193L960,805.83ZM0,803.17v244.41L960,660.4l960,387.18V803.17L960,416ZM0,0V761.28L960,374.1l960,387.18V0Z"/>',
					'square'    => '<path d="M960,539.93l960,387.18v100.63L960,640.57,0,1027.75V927.11Zm0,353.9L0,1281v28.76L960,922.58l960,387.18V1281L965,895.84ZM0,495.37,960,108.19l960,387.18V0H0Zm0,41.9v244.4L960,394.49l960,387.18V537.27L960,150.09Zm960,687.22L0,1611.67V1615l960-387.18L1920,1615v-3.33L960.58,1224.73Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Chevrons();
