/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-02-06 14:56:09 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `jx_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1771 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

CREATE TABLE `jx_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1945 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1766 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_wpr_rocket_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_wpr_rucss_used_css` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `error_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error_message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `unprocessedcss` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT '1',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `job_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `queue_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `hash` (`hash`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `jx_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jx_yoast_prominent_words` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `stem` varchar(191) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `weight` float DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stem` (`stem`),
  KEY `indexable_id` (`indexable_id`),
  KEY `indexable_id_and_stem` (`indexable_id`,`stem`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `jx_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: jx_actionscheduler_actions */
INSERT INTO `jx_actionscheduler_actions` VALUES("1767", "action_scheduler/migration_hook", "pending", "2023-11-20 15:02:21", "2023-11-20 16:02:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700492541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700492541;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `jx_actionscheduler_actions` VALUES("1768", "rocket_preload_job_check_finished", "canceled", "2023-11-20 15:02:21", "2023-11-20 16:02:21", "[1700492481]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700492541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700492541;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `jx_actionscheduler_actions` VALUES("1769", "rocket_preload_job_load_initial_sitemap", "pending", "2023-11-20 15:01:22", "2023-11-20 15:01:22", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `jx_actionscheduler_actions` VALUES("1770", "rocket_preload_job_check_finished", "pending", "2023-11-20 15:02:23", "2023-11-20 16:02:23", "[1700492483]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1700492543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1700492543;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: jx_actionscheduler_groups */
INSERT INTO `jx_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `jx_actionscheduler_groups` VALUES("2", "rocket-preload");

/* INSERT TABLE DATA: jx_actionscheduler_logs */
INSERT INTO `jx_actionscheduler_logs` VALUES("1", "1767", "action created", "2023-11-20 15:01:21", "2023-11-20 16:01:21");
INSERT INTO `jx_actionscheduler_logs` VALUES("2", "1768", "action created", "2023-11-20 15:01:21", "2023-11-20 16:01:21");
INSERT INTO `jx_actionscheduler_logs` VALUES("3", "1768", "action canceled", "2023-11-20 15:01:22", "2023-11-20 16:01:22");
INSERT INTO `jx_actionscheduler_logs` VALUES("4", "1768", "action canceled", "2023-11-20 15:01:22", "2023-11-20 16:01:22");
INSERT INTO `jx_actionscheduler_logs` VALUES("5", "1769", "action created", "2023-11-20 15:01:22", "2023-11-20 16:01:22");
INSERT INTO `jx_actionscheduler_logs` VALUES("6", "1770", "action created", "2023-11-20 15:01:23", "2023-11-20 16:01:23");

/* INSERT TABLE DATA: jx_duplicator_packages */
INSERT INTO `jx_duplicator_packages` VALUES("9", "20240206_master", "29501023aca36dec2276_20240206145603", "22", "2024-02-06 14:56:09", "root_alminora", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-02-06 14:56:03\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:9;s:4:\"Name\";s:15:\"20240206_master\";s:4:\"Hash\";s:35:\"29501023aca36dec2276_20240206145603\";s:8:\"NameHash\";s:51:\"20240206_master_29501023aca36dec2276_20240206145603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:61:\"20240206_master_29501023aca36dec2276_20240206145603_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.4\";s:6:\"WPUser\";s:13:\"root_alminora\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:63:\"20240206_master_29501023aca36dec2276_20240206145603_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/cursopowerbidayd/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1534;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:8916;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-02-06 14:56:03\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:15:\"20240206_master\";s:4:\"Hash\";s:35:\"29501023aca36dec2276_20240206145603\";s:8:\"NameHash\";s:51:\"20240206_master_29501023aca36dec2276_20240206145603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:69:\"20240206_master_29501023aca36dec2276_20240206145603_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/cursopowerbidayd/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:64:\"20240206_master_29501023aca36dec2276_20240206145603_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:131:\"/home/cursopowerbidayd/public_html/wp-content/backups-dup-lite/tmp/20240206_master_29501023aca36dec2276_20240206145603_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/cursopowerbidayd/public_html/wp-admin\";i:1;s:46:\"/home/cursopowerbidayd/public_html/wp-includes\";i:2;s:55:\"/home/cursopowerbidayd/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/cursopowerbidayd/public_html\";i:1;s:34:\"/home/cursopowerbidayd/public_html\";i:2;s:45:\"/home/cursopowerbidayd/public_html/wp-content\";i:3;s:53:\"/home/cursopowerbidayd/public_html/wp-content/uploads\";i:4;s:53:\"/home/cursopowerbidayd/public_html/wp-content/plugins\";i:5;s:56:\"/home/cursopowerbidayd/public_html/wp-content/mu-plugins\";i:6;s:52:\"/home/cursopowerbidayd/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/cursopowerbidayd/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: jx_options */
INSERT INTO `jx_options` VALUES("1", "siteurl", "http://cursopowerbi-dayde.es", "yes");
INSERT INTO `jx_options` VALUES("2", "home", "http://cursopowerbi-dayde.es", "yes");
INSERT INTO `jx_options` VALUES("3", "blogname", "Máster", "yes");
INSERT INTO `jx_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `jx_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `jx_options` VALUES("6", "admin_email", "dedalo.digital.wp@gmail.com", "yes");
INSERT INTO `jx_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `jx_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `jx_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `jx_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `jx_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `jx_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `jx_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `jx_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `jx_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `jx_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `jx_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `jx_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `jx_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `jx_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `jx_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `jx_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `jx_options` VALUES("23", "date_format", "j \\d\\e F \\d\\e Y", "yes");
INSERT INTO `jx_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `jx_options` VALUES("25", "links_updated_date_format", "j \\d\\e F \\d\\e Y H:i", "yes");
INSERT INTO `jx_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `jx_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `jx_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `jx_options` VALUES("29", "rewrite_rules", "a:305:{s:20:\"brainaddons-popup/?$\";s:37:\"index.php?post_type=brainaddons-popup\";s:50:\"brainaddons-popup/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=brainaddons-popup&feed=$matches[1]\";s:45:\"brainaddons-popup/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=brainaddons-popup&feed=$matches[1]\";s:37:\"brainaddons-popup/page/([0-9]{1,})/?$\";s:55:\"index.php?post_type=brainaddons-popup&paged=$matches[1]\";s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:45:\"brainaddons-popup/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"brainaddons-popup/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"brainaddons-popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"brainaddons-popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"brainaddons-popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"brainaddons-popup/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"brainaddons-popup/([^/]+)/embed/?$\";s:50:\"index.php?brainaddons-popup=$matches[1]&embed=true\";s:38:\"brainaddons-popup/([^/]+)/trackback/?$\";s:44:\"index.php?brainaddons-popup=$matches[1]&tb=1\";s:58:\"brainaddons-popup/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?brainaddons-popup=$matches[1]&feed=$matches[2]\";s:53:\"brainaddons-popup/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?brainaddons-popup=$matches[1]&feed=$matches[2]\";s:46:\"brainaddons-popup/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?brainaddons-popup=$matches[1]&paged=$matches[2]\";s:53:\"brainaddons-popup/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?brainaddons-popup=$matches[1]&cpage=$matches[2]\";s:42:\"brainaddons-popup/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?brainaddons-popup=$matches[1]&page=$matches[2]\";s:34:\"brainaddons-popup/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"brainaddons-popup/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"brainaddons-popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"brainaddons-popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"brainaddons-popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"brainaddons-popup/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"noticias/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"noticias/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"noticias/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"noticias/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"noticias/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:48:\"index.php?layout_category=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?layout_category=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:37:\"index.php?layout_category=$matches[1]\";s:51:\"layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?layout_tag=$matches[1]&feed=$matches[2]\";s:46:\"layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?layout_tag=$matches[1]&feed=$matches[2]\";s:27:\"layout_tag/([^/]+)/embed/?$\";s:43:\"index.php?layout_tag=$matches[1]&embed=true\";s:39:\"layout_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?layout_tag=$matches[1]&paged=$matches[2]\";s:21:\"layout_tag/([^/]+)/?$\";s:32:\"index.php?layout_tag=$matches[1]\";s:56:\"et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]\";s:51:\"et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]\";s:32:\"et_tb_item_type/([^/]+)/embed/?$\";s:48:\"index.php?et_tb_item_type=$matches[1]&embed=true\";s:44:\"et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?et_tb_item_type=$matches[1]&paged=$matches[2]\";s:26:\"et_tb_item_type/([^/]+)/?$\";s:37:\"index.php?et_tb_item_type=$matches[1]\";s:38:\"et_tb_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"et_tb_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"et_tb_item/([^/]+)/embed/?$\";s:58:\"index.php?post_type=et_tb_item&name=$matches[1]&embed=true\";s:31:\"et_tb_item/([^/]+)/trackback/?$\";s:52:\"index.php?post_type=et_tb_item&name=$matches[1]&tb=1\";s:39:\"et_tb_item/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]\";s:46:\"et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]\";s:35:\"et_tb_item/([^/]+)(?:/([0-9]+))?/?$\";s:64:\"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]\";s:27:\"et_tb_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"et_tb_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"et_tb_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:44:\"et_theme_options/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_options/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_options/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_options/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_options/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_options/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_options/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_options&name=$matches[1]&embed=true\";s:37:\"et_theme_options/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_options&name=$matches[1]&tb=1\";s:45:\"et_theme_options/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_options/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_options/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_options&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_options/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_options/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_options/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_options/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_options/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_options/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"et_code_snippet_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:56:\"et_code_snippet_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:37:\"et_code_snippet_type/([^/]+)/embed/?$\";s:53:\"index.php?et_code_snippet_type=$matches[1]&embed=true\";s:49:\"et_code_snippet_type/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?et_code_snippet_type=$matches[1]&paged=$matches[2]\";s:31:\"et_code_snippet_type/([^/]+)/?$\";s:42:\"index.php?et_code_snippet_type=$matches[1]\";s:43:\"et_code_snippet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"et_code_snippet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"et_code_snippet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"et_code_snippet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"et_code_snippet/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"et_code_snippet/([^/]+)/embed/?$\";s:63:\"index.php?post_type=et_code_snippet&name=$matches[1]&embed=true\";s:36:\"et_code_snippet/([^/]+)/trackback/?$\";s:57:\"index.php?post_type=et_code_snippet&name=$matches[1]&tb=1\";s:44:\"et_code_snippet/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&paged=$matches[2]\";s:51:\"et_code_snippet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&cpage=$matches[2]\";s:40:\"et_code_snippet/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?post_type=et_code_snippet&name=$matches[1]&page=$matches[2]\";s:32:\"et_code_snippet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"et_code_snippet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"et_code_snippet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"et_code_snippet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"et_code_snippet/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `jx_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `jx_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `jx_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `jx_options` VALUES("33", "active_plugins", "a:6:{i:0;s:33:\"classic-editor/classic-editor.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:26:\"popups-for-divi/plugin.php\";i:3;s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";i:4;s:35:\"addons-for-divi/addons-for-divi.php\";i:5;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `jx_options` VALUES("34", "category_base", "/noticias", "yes");
INSERT INTO `jx_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `jx_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `jx_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `jx_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `jx_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `jx_options` VALUES("40", "template", "Divi", "yes");
INSERT INTO `jx_options` VALUES("41", "stylesheet", "Divi", "yes");
INSERT INTO `jx_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `jx_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `jx_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `jx_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `jx_options` VALUES("46", "db_version", "56657", "yes");
INSERT INTO `jx_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `jx_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `jx_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `jx_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `jx_options` VALUES("51", "show_on_front", "posts", "yes");
INSERT INTO `jx_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `jx_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `jx_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `jx_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `jx_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `jx_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `jx_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `jx_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `jx_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `jx_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `jx_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `jx_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `jx_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `jx_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `jx_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `jx_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `jx_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `jx_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `jx_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `jx_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `jx_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `jx_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `jx_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `jx_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("79", "uninstall_plugins", "a:2:{s:33:\"divi-mega-menu/divi-mega-menu.php\";s:21:\"de_dmm_uninstall_hook\";s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}", "no");
INSERT INTO `jx_options` VALUES("80", "timezone_string", "Europe/Madrid", "yes");
INSERT INTO `jx_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `jx_options` VALUES("82", "page_on_front", "0", "yes");
INSERT INTO `jx_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `jx_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `jx_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `jx_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `jx_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `jx_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `jx_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `jx_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `jx_options` VALUES("91", "admin_email_lifespan", "1710580463", "yes");
INSERT INTO `jx_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `jx_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `jx_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `jx_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `jx_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `jx_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `jx_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `jx_options` VALUES("100", "jx_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:68:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"rocket_purge_opcache\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `jx_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `jx_options` VALUES("102", "WPLANG", "es_ES", "yes");
INSERT INTO `jx_options` VALUES("103", "user_count", "1", "no");
INSERT INTO `jx_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:160:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Entradas recientes</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Comentarios recientes</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archivos</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categorías</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("105", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `jx_options` VALUES("106", "cron", "a:12:{i:1707232110;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1707250110;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1707250154;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1707250155;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1707291735;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1707294589;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1707317588;a:1:{s:26:\"dm_admin_cron_notice_check\";a:1:{s:32:\"dd4d6eb78a154fb59dc300ada4733b5a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:2:{i:0;s:3:\"pfd\";i:1;s:2:\"dm\";}s:8:\"interval\";i:86400;}}}i:1707422910;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1707492505;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}i:1707742800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1707826998;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `jx_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("124", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1678980505;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `jx_options` VALUES("127", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("128", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:26:\"Verificación SSL fallida.\";}}", "yes");
INSERT INTO `jx_options` VALUES("161", "finished_updating_comment_type", "1", "yes");
INSERT INTO `jx_options` VALUES("178", "category_children", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("179", "recently_activated", "a:1:{s:23:\"wp-rocket/wp-rocket.php\";i:1700492484;}", "yes");
INSERT INTO `jx_options` VALUES("195", "duplicator_version_plugin", "1.5.7.1", "yes");
INSERT INTO `jx_options` VALUES("450", "current_theme", "Divi", "yes");
INSERT INTO `jx_options` VALUES("451", "theme_mods_Divi", "a:5:{i:0;b:0;s:18:\"custom_css_post_id\";i:27;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:0:{}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}", "yes");
INSERT INTO `jx_options` VALUES("452", "theme_switched", "", "yes");
INSERT INTO `jx_options` VALUES("453", "et_pb_cache_notice", "a:1:{s:6:\"4.20.2\";s:6:\"ignore\";}", "yes");
INSERT INTO `jx_options` VALUES("458", "et_core_version", "4.23.1", "yes");
INSERT INTO `jx_options` VALUES("460", "et_divi", "a:171:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:29:\"presets_storage_migrated_flag\";b:1;s:39:\"builder_global_presets_history_migrated\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:6:\"4.23.1\";s:31:\"divi_previous_installed_version\";s:6:\"4.22.2\";s:29:\"divi_latest_installed_version\";s:6:\"4.23.1\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:29:\"custom_defaults_migrated_flag\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:19:\"product_tour_status\";a:2:{i:1;s:3:\"off\";i:8;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:46:\"et_fb_pref_builder_enable_visual_theme_builder\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:28:\"et_fb_pref_limited_view_mode\";s:9:\"wireframe\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:35:\"et_fb_pref_limited_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:400;s:33:\"et_fb_pref_modal_dimension_height\";i:400;s:27:\"et_fb_pref_modal_position_x\";i:660;s:27:\"et_fb_pref_modal_position_y\";i:50;s:32:\"et_fb_pref_limited_toolbar_click\";s:5:\"false\";s:34:\"et_fb_pref_limited_toolbar_desktop\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_grid\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_hover\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_phone\";s:4:\"true\";s:33:\"et_fb_pref_limited_toolbar_tablet\";s:4:\"true\";s:36:\"et_fb_pref_limited_toolbar_wireframe\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:0;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:0;s:30:\"et_fb_pref_lv_modal_position_x\";i:0;s:30:\"et_fb_pref_lv_modal_position_y\";i:0;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:9:\"divi_logo\";s:0:\"\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:2:\"on\";s:24:\"divi_show_instagram_icon\";s:2:\"on\";s:18:\"divi_show_rss_icon\";s:2:\"on\";s:17:\"divi_facebook_url\";s:1:\"#\";s:16:\"divi_twitter_url\";s:1:\"#\";s:18:\"divi_instagram_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:16:\"divi_back_to_top\";s:5:\"false\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:25:\"divi_disable_translations\";s:5:\"false\";s:29:\"divi_enable_responsive_images\";s:2:\"on\";s:15:\"divi_custom_css\";s:0:\"\";s:29:\"divi_dynamic_module_framework\";s:2:\"on\";s:16:\"divi_dynamic_css\";s:2:\"on\";s:18:\"divi_dynamic_icons\";s:2:\"on\";s:22:\"divi_inline_stylesheet\";s:2:\"on\";s:17:\"divi_critical_css\";s:2:\"on\";s:30:\"divi_critical_threshold_height\";s:4:\"Bajo\";s:25:\"divi_dynamic_js_libraries\";s:2:\"on\";s:19:\"divi_disable_emojis\";s:2:\"on\";s:20:\"divi_defer_block_css\";s:2:\"on\";s:24:\"divi_google_fonts_inline\";s:5:\"false\";s:51:\"divi_limit_google_fonts_support_for_legacy_browsers\";s:2:\"on\";s:23:\"divi_enable_jquery_body\";s:2:\"on\";s:32:\"divi_enable_jquery_compatibility\";s:2:\"on\";s:29:\"divi_enable_jquery_body_super\";s:5:\"false\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:4:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:17:\"brainaddons-popup\";s:2:\"on\";s:7:\"project\";s:2:\"on\";}s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:3:\"off\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";}", "yes");
INSERT INTO `jx_options` VALUES("461", "widget_aboutmewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("462", "widget_adsensewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("463", "widget_advwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("464", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("465", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}", "yes");
INSERT INTO `jx_options` VALUES("466", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `jx_options` VALUES("467", "et_safe_mode_plugins_allowlist", "a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}", "yes");
INSERT INTO `jx_options` VALUES("468", "et_support_center_installed", "true", "yes");
INSERT INTO `jx_options` VALUES("469", "et_images_temp_folder", "/home/cursopowerbidayd/public_html/wp-content/uploads/et_temp", "yes");
INSERT INTO `jx_options` VALUES("470", "et_schedule_clean_images_last_time", "1707230338", "yes");
INSERT INTO `jx_options` VALUES("471", "et_bfb_settings", "a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}", "yes");
INSERT INTO `jx_options` VALUES("473", "et_pb_builder_options", "a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}", "yes");
INSERT INTO `jx_options` VALUES("474", "et_divi_builder_global_presets_ng", "O:8:\"stdClass\":0:{}", "no");
INSERT INTO `jx_options` VALUES("475", "et_support_center_setup_done", "processed", "yes");
INSERT INTO `jx_options` VALUES("487", "et_account_status", "active", "no");
INSERT INTO `jx_options` VALUES("506", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `jx_options` VALUES("507", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("564", "et_google_api_settings", "a:3:{s:7:\"api_key\";s:0:\"\";s:16:\"use_google_fonts\";s:2:\"on\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";}", "yes");
INSERT INTO `jx_options` VALUES("565", "et_automatic_updates_options", "a:2:{s:8:\"username\";s:14:\"CAPTABILIDADES\";s:7:\"api_key\";s:40:\"e905dacdf3a0cdce7400be4c4138ac9af2f36d4e\";}", "no");
INSERT INTO `jx_options` VALUES("566", "et_support_site_id", "pPEUzBHKmJaOXVk8FyGd", "yes");
INSERT INTO `jx_options` VALUES("582", "dt-version", "3.6.1", "yes");
INSERT INTO `jx_options` VALUES("598", "dsm-supreme-modules-for-divi-activation-date", "1679569155", "no");
INSERT INTO `jx_options` VALUES("603", "dsm_general", "", "yes");
INSERT INTO `jx_options` VALUES("604", "dsm_theme_builder", "", "yes");
INSERT INTO `jx_options` VALUES("605", "dsm_settings_social_media", "", "yes");
INSERT INTO `jx_options` VALUES("606", "dsm_settings_misc", "", "yes");
INSERT INTO `jx_options` VALUES("647", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:27:\"dedalo.digital.wp@gmail.com\";s:7:\"version\";s:5:\"6.4.3\";s:9:\"timestamp\";i:1707230359;}", "no");
INSERT INTO `jx_options` VALUES("1032", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `jx_options` VALUES("1033", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `jx_options` VALUES("1224", "duplicator_notifications", "a:4:{s:6:\"update\";i:1707230523;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `jx_options` VALUES("1251", "ba_display_conditions", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("1345", "db_upgraded", "", "yes");
INSERT INTO `jx_options` VALUES("1435", "duplicator_settings", "a:19:{s:7:\"version\";s:7:\"1.5.7.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:9;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `jx_options` VALUES("1503", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-02-06 14:56:03\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:15:\"20240206_master\";s:4:\"Hash\";s:35:\"29501023aca36dec2276_20240206145603\";s:8:\"NameHash\";s:51:\"20240206_master_29501023aca36dec2276_20240206145603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:61:\"20240206_master_29501023aca36dec2276_20240206145603_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/cursopowerbidayd/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1534;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:8916;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-02-06 14:56:03\";s:7:\"Version\";s:7:\"1.5.7.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:15:\"20240206_master\";s:4:\"Hash\";s:35:\"29501023aca36dec2276_20240206145603\";s:8:\"NameHash\";s:51:\"20240206_master_29501023aca36dec2276_20240206145603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/cursopowerbidayd/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/cursopowerbidayd/public_html/wp-admin\";i:1;s:46:\"/home/cursopowerbidayd/public_html/wp-includes\";i:2;s:55:\"/home/cursopowerbidayd/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/cursopowerbidayd/public_html\";i:1;s:34:\"/home/cursopowerbidayd/public_html\";i:2;s:45:\"/home/cursopowerbidayd/public_html/wp-content\";i:3;s:53:\"/home/cursopowerbidayd/public_html/wp-content/uploads\";i:4;s:53:\"/home/cursopowerbidayd/public_html/wp-content/plugins\";i:5;s:56:\"/home/cursopowerbidayd/public_html/wp-content/mu-plugins\";i:6;s:52:\"/home/cursopowerbidayd/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/cursopowerbidayd/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `jx_options` VALUES("1587", "yoast_premium_as_an_addon_installer", "completed", "yes");
INSERT INTO `jx_options` VALUES("1588", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"21.3\";}", "yes");
INSERT INTO `jx_options` VALUES("1589", "wpseo", "a:106:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:13:\"first_install\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:100:\"6ONdVw4pmgPvnApYO05c8i4-0m2TDfPl0T0GFo1OanS2Voek1S2PEo8N6yGJJuzTf6GPH02X5WtE16FAX7M-Q9nfu9hry00RD6Sr\";s:7:\"version\";s:4:\"21.3\";s:16:\"previous_version\";s:5:\"19.14\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1697012989;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:0:\"\";s:8:\"home_url\";s:0:\"\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1697012994;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:17:\"brainaddons-popup\";i:3;s:7:\"project\";}s:28:\"last_known_public_taxonomies\";a:9:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:15:\"layout_category\";i:4;s:10:\"layout_tag\";i:5;s:15:\"et_tb_item_type\";i:6;s:16:\"project_category\";i:7;s:11:\"project_tag\";i:8;s:20:\"et_code_snippet_type\";}s:23:\"last_known_no_unindexed\";a:2:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1697013022;s:31:\"wpseo_unindexed_term_link_count\";i:1697013022;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;}", "yes");
INSERT INTO `jx_options` VALUES("1590", "wpseo_titles", "a:202:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:23:\"title-brainaddons-popup\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-brainaddons-popup\";s:0:\"\";s:25:\"noindex-brainaddons-popup\";b:0;s:36:\"display-metabox-pt-brainaddons-popup\";b:1;s:36:\"post_types-brainaddons-popup-maintax\";i:0;s:34:\"schema-page-type-brainaddons-popup\";s:7:\"WebPage\";s:37:\"schema-article-type-brainaddons-popup\";s:4:\"None\";s:30:\"social-title-brainaddons-popup\";s:9:\"%%title%%\";s:36:\"social-description-brainaddons-popup\";s:0:\"\";s:34:\"social-image-url-brainaddons-popup\";s:0:\"\";s:33:\"social-image-id-brainaddons-popup\";i:0;s:33:\"title-ptarchive-brainaddons-popup\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:36:\"metadesc-ptarchive-brainaddons-popup\";s:0:\"\";s:35:\"bctitle-ptarchive-brainaddons-popup\";s:0:\"\";s:35:\"noindex-ptarchive-brainaddons-popup\";b:0;s:40:\"social-title-ptarchive-brainaddons-popup\";s:21:\"%%pt_plural%% Archive\";s:46:\"social-description-ptarchive-brainaddons-popup\";s:0:\"\";s:44:\"social-image-url-ptarchive-brainaddons-popup\";s:0:\"\";s:43:\"social-image-id-ptarchive-brainaddons-popup\";i:0;s:13:\"title-project\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-project\";s:0:\"\";s:15:\"noindex-project\";b:0;s:26:\"display-metabox-pt-project\";b:1;s:26:\"post_types-project-maintax\";i:0;s:24:\"schema-page-type-project\";s:7:\"WebPage\";s:27:\"schema-article-type-project\";s:4:\"None\";s:20:\"social-title-project\";s:9:\"%%title%%\";s:26:\"social-description-project\";s:0:\"\";s:24:\"social-image-url-project\";s:0:\"\";s:23:\"social-image-id-project\";i:0;s:23:\"title-ptarchive-project\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-project\";s:0:\"\";s:25:\"bctitle-ptarchive-project\";s:0:\"\";s:25:\"noindex-ptarchive-project\";b:0;s:30:\"social-title-ptarchive-project\";s:21:\"%%pt_plural%% Archive\";s:36:\"social-description-ptarchive-project\";s:0:\"\";s:34:\"social-image-url-ptarchive-project\";s:0:\"\";s:33:\"social-image-id-ptarchive-project\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:25:\"title-tax-layout_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-layout_category\";s:0:\"\";s:35:\"display-metabox-tax-layout_category\";b:1;s:27:\"noindex-tax-layout_category\";b:0;s:32:\"social-title-tax-layout_category\";s:23:\"%%term_title%% Archives\";s:38:\"social-description-tax-layout_category\";s:0:\"\";s:36:\"social-image-url-tax-layout_category\";s:0:\"\";s:35:\"social-image-id-tax-layout_category\";i:0;s:33:\"taxonomy-layout_category-ptparent\";i:0;s:20:\"title-tax-layout_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-layout_tag\";s:0:\"\";s:30:\"display-metabox-tax-layout_tag\";b:1;s:22:\"noindex-tax-layout_tag\";b:0;s:27:\"social-title-tax-layout_tag\";s:23:\"%%term_title%% Archives\";s:33:\"social-description-tax-layout_tag\";s:0:\"\";s:31:\"social-image-url-tax-layout_tag\";s:0:\"\";s:30:\"social-image-id-tax-layout_tag\";i:0;s:28:\"taxonomy-layout_tag-ptparent\";i:0;s:25:\"title-tax-et_tb_item_type\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-et_tb_item_type\";s:0:\"\";s:35:\"display-metabox-tax-et_tb_item_type\";b:1;s:27:\"noindex-tax-et_tb_item_type\";b:0;s:32:\"social-title-tax-et_tb_item_type\";s:23:\"%%term_title%% Archives\";s:38:\"social-description-tax-et_tb_item_type\";s:0:\"\";s:36:\"social-image-url-tax-et_tb_item_type\";s:0:\"\";s:35:\"social-image-id-tax-et_tb_item_type\";i:0;s:33:\"taxonomy-et_tb_item_type-ptparent\";i:0;s:26:\"title-tax-project_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-project_category\";s:0:\"\";s:36:\"display-metabox-tax-project_category\";b:1;s:28:\"noindex-tax-project_category\";b:0;s:33:\"social-title-tax-project_category\";s:23:\"%%term_title%% Archives\";s:39:\"social-description-tax-project_category\";s:0:\"\";s:37:\"social-image-url-tax-project_category\";s:0:\"\";s:36:\"social-image-id-tax-project_category\";i:0;s:34:\"taxonomy-project_category-ptparent\";i:0;s:21:\"title-tax-project_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-project_tag\";s:0:\"\";s:31:\"display-metabox-tax-project_tag\";b:1;s:23:\"noindex-tax-project_tag\";b:0;s:28:\"social-title-tax-project_tag\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-project_tag\";s:0:\"\";s:32:\"social-image-url-tax-project_tag\";s:0:\"\";s:31:\"social-image-id-tax-project_tag\";i:0;s:29:\"taxonomy-project_tag-ptparent\";i:0;s:30:\"title-tax-et_code_snippet_type\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:33:\"metadesc-tax-et_code_snippet_type\";s:0:\"\";s:40:\"display-metabox-tax-et_code_snippet_type\";b:1;s:32:\"noindex-tax-et_code_snippet_type\";b:0;s:37:\"social-title-tax-et_code_snippet_type\";s:23:\"%%term_title%% Archives\";s:43:\"social-description-tax-et_code_snippet_type\";s:0:\"\";s:41:\"social-image-url-tax-et_code_snippet_type\";s:0:\"\";s:40:\"social-image-id-tax-et_code_snippet_type\";i:0;s:38:\"taxonomy-et_code_snippet_type-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `jx_options` VALUES("1591", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}}", "yes");
INSERT INTO `jx_options` VALUES("1592", "yoast_migrations_premium", "a:1:{s:7:\"version\";s:4:\"19.7\";}", "yes");
INSERT INTO `jx_options` VALUES("1593", "wpseo_premium", "a:4:{s:34:\"prominent_words_indexing_completed\";N;s:8:\"workouts\";a:1:{s:11:\"cornerstone\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:29:\"should_redirect_after_install\";b:0;s:29:\"activation_redirect_timestamp\";i:1697012994;}", "yes");
INSERT INTO `jx_options` VALUES("1598", "wpseo_current_version", "16", "no");
INSERT INTO `jx_options` VALUES("1599", "wpseo_premium_version", "19.7", "yes");
INSERT INTO `jx_options` VALUES("1600", "wpseo-premium-redirects-export-plain", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("1601", "wpseo-premium-redirects-export-regex", "a:0:{}", "yes");
INSERT INTO `jx_options` VALUES("1631", "wpseo_sitemap_cache_validator_global", "3dULT", "no");
INSERT INTO `jx_options` VALUES("1632", "wpseo_tracking_last_request", "1697012994", "yes");
INSERT INTO `jx_options` VALUES("1690", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `jx_options` VALUES("1714", "can_compress_scripts", "1", "yes");
INSERT INTO `jx_options` VALUES("1759", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "yes");
INSERT INTO `jx_options` VALUES("1760", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.6\";s:4:\"time\";i:1678911639;s:10:\"updateTime\";i:1700491931;}", "no");
INSERT INTO `jx_options` VALUES("1799", "dm_pfd_data", "a:1:{s:12:\"active_since\";i:1700491988;}", "yes");
INSERT INTO `jx_options` VALUES("1800", "dm_core_notices", "a:1:{s:5:\"queue\";a:1:{i:108636;a:3:{s:4:\"inst\";s:3:\"pfd\";s:4:\"type\";s:4:\"info\";s:4:\"html\";s:858:\"<p><strong>You\'re using Popups for Divi</strong> for a while now, thanks! If you require any assistance, please <a href=\"https://wordpress.org/support/plugin/popups-for-divi/#new-post\" target=\"_blank\">reach out via support</a>, and we\'ll get back to you asap. <p>Meanwhile, you can do us a <strong>huge favor</strong> and leave an <a href=\"https://wordpress.org/support/plugin/popups-for-divi/reviews/#new-post\" target=\"_blank\"><strong>honest (5-star) rating</strong> on WordPress</a> - it only takes 30 seconds, and helps other users to find our plugin, and it enables us to spend more time developing and improving this free plugin for you. <em>- Thanks, Philipp from divimode.com</em> 👍 <br /><br><br><a href=\"https://wordpress.org/support/plugin/popups-for-divi/reviews/#new-post\" target=\"_blank\" class=\"button-primary\">Sure, I\'d love to help!</a></p>\";}}}", "yes");
INSERT INTO `jx_options` VALUES("1820", "wpr_rucss_used_css_version", "20231010", "yes");
INSERT INTO `jx_options` VALUES("1821", "rocket_cache_dir_size_check", "1", "yes");
INSERT INTO `jx_options` VALUES("1823", "wp_rocket_settings", "a:84:{s:16:\"secret_cache_key\";s:22:\"655b72f40e96f526386347\";s:12:\"cache_mobile\";i:1;s:23:\"do_caching_mobile_files\";i:0;s:10:\"cache_webp\";i:0;s:17:\"cache_logged_user\";i:0;s:9:\"cache_ssl\";i:1;s:5:\"emoji\";i:1;s:6:\"embeds\";i:0;s:16:\"cache_reject_uri\";a:0:{}s:20:\"cache_reject_cookies\";a:0:{}s:15:\"cache_reject_ua\";a:0:{}s:19:\"cache_query_strings\";a:0:{}s:17:\"cache_purge_pages\";a:0:{}s:19:\"purge_cron_interval\";i:10;s:15:\"purge_cron_unit\";s:15:\"HOUR_IN_SECONDS\";s:11:\"exclude_css\";a:0:{}s:10:\"exclude_js\";a:0:{}s:17:\"exclude_inline_js\";a:0:{}s:12:\"defer_all_js\";i:0;s:9:\"async_css\";i:0;s:12:\"critical_css\";s:0:\"\";s:8:\"lazyload\";i:0;s:16:\"lazyload_iframes\";i:0;s:16:\"lazyload_youtube\";i:0;s:10:\"minify_css\";i:0;s:14:\"minify_css_key\";s:22:\"655b72f40e979673075414\";s:22:\"minify_concatenate_css\";i:0;s:9:\"minify_js\";i:0;s:13:\"minify_js_key\";s:22:\"655b72f40e97c220174996\";s:21:\"minify_concatenate_js\";i:0;s:19:\"minify_google_fonts\";i:1;s:14:\"manual_preload\";i:1;s:15:\"sitemap_preload\";i:0;s:25:\"sitemap_preload_url_crawl\";s:6:\"500000\";s:8:\"sitemaps\";a:0:{}s:12:\"dns_prefetch\";a:0:{}s:13:\"preload_fonts\";a:0:{}s:18:\"database_revisions\";i:0;s:20:\"database_auto_drafts\";i:0;s:22:\"database_trashed_posts\";i:0;s:22:\"database_spam_comments\";i:0;s:25:\"database_trashed_comments\";i:0;s:27:\"database_expired_transients\";i:0;s:23:\"database_all_transients\";i:0;s:24:\"database_optimize_tables\";i:0;s:26:\"schedule_automatic_cleanup\";i:0;s:27:\"automatic_cleanup_frequency\";s:0:\"\";s:3:\"cdn\";i:0;s:10:\"cdn_cnames\";a:0:{}s:8:\"cdn_zone\";a:0:{}s:16:\"cdn_reject_files\";a:0:{}s:13:\"do_cloudflare\";i:0;s:16:\"cloudflare_email\";s:0:\"\";s:18:\"cloudflare_api_key\";s:0:\"\";s:18:\"cloudflare_zone_id\";s:0:\"\";s:18:\"cloudflare_devmode\";i:0;s:27:\"cloudflare_protocol_rewrite\";i:0;s:24:\"cloudflare_auto_settings\";i:0;s:23:\"cloudflare_old_settings\";s:0:\"\";s:17:\"control_heartbeat\";i:1;s:23:\"heartbeat_site_behavior\";s:18:\"reduce_periodicity\";s:24:\"heartbeat_admin_behavior\";s:18:\"reduce_periodicity\";s:25:\"heartbeat_editor_behavior\";s:18:\"reduce_periodicity\";s:18:\"varnish_auto_purge\";i:0;s:17:\"analytics_enabled\";i:0;s:21:\"sucury_waf_cache_sync\";i:0;s:18:\"sucury_waf_api_key\";s:0:\"\";s:16:\"async_css_mobile\";i:1;s:16:\"exclude_defer_js\";a:0:{}s:8:\"delay_js\";i:0;s:19:\"delay_js_exclusions\";a:0:{}s:17:\"remove_unused_css\";i:0;s:26:\"remove_unused_css_safelist\";a:0:{}s:13:\"preload_links\";i:1;s:16:\"image_dimensions\";i:0;s:16:\"exclude_lazyload\";a:0:{}s:12:\"consumer_key\";s:8:\"73b143bc\";s:14:\"consumer_email\";s:18:\"josemilp@gmail.com\";s:10:\"secret_key\";s:8:\"bd4cc02c\";s:7:\"version\";s:6:\"3.15.4\";s:7:\"license\";i:1700492022;s:20:\"preload_excluded_uri\";a:0:{}s:28:\"delay_js_exclusions_selected\";a:0:{}s:39:\"delay_js_exclusions_selected_exclusions\";a:0:{}}", "yes");
INSERT INTO `jx_options` VALUES("1867", "action_scheduler_hybrid_store_demarkation", "1766", "yes");
INSERT INTO `jx_options` VALUES("1868", "schema-ActionScheduler_StoreSchema", "6.0.1700492480", "yes");
INSERT INTO `jx_options` VALUES("1869", "schema-ActionScheduler_LoggerSchema", "3.0.1700492480", "yes");
INSERT INTO `jx_options` VALUES("1872", "wpr_rocket_cache_version", "20220927", "yes");
INSERT INTO `jx_options` VALUES("1873", "wp_rocket_last_base_url", "aHR0cDovL2N1cnNvcG93ZXJiaS1kYXlkZS5lcy8=", "yes");
INSERT INTO `jx_options` VALUES("1874", "wp_rocket_no_licence", "0", "yes");
INSERT INTO `jx_options` VALUES("1891", "new_admin_email", "dedalo.digital.wp@gmail.com", "yes");
INSERT INTO `jx_options` VALUES("1898", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.7.1\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/cursopowerbidayd\\/public_html\\/20230920_alminora_422ace212e512e289739_20231120150237_archive.zip\",\n    \"packageHash\": \"422ace2-20150237\",\n    \"installerPath\": \"\\/home\\/cursopowerbidayd\\/public_html\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/cursopowerbidayd\\/public_html\\/dup-installer-bootlog__d8a7e47-20150237.txt\",\n    \"installerLog\": \"\\/home\\/cursopowerbidayd\\/public_html\\/dup-installer\\/dup-installer-log__d8a7e47-20150237.txt\",\n    \"dupInstallerPath\": \"\\/home\\/cursopowerbidayd\\/public_html\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/cursopowerbidayd\\/public_html\\/dup-installer\\/original_files_422ace2-20150237\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"8.1.25\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 58221079,\n    \"siteNumFiles\": 10452,\n    \"siteDbSize\": 2494500,\n    \"siteDBNumTables\": 25,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1707230338\n}", "no");
INSERT INTO `jx_options` VALUES("1904", "_transient_timeout__et_builder_gf_feature_cache", "1707316739", "no");
INSERT INTO `jx_options` VALUES("1905", "_transient__et_builder_gf_feature_cache", "1", "no");
INSERT INTO `jx_options` VALUES("1909", "_site_transient_timeout_available_translations", "1707241139", "no");
INSERT INTO `jx_options` VALUES("1910", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.7/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-24 10:35:39\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-19 09:22:30\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2023-12-01 14:08:36\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.25/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 09:13:37\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-05 07:41:05\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-01 18:55:37\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 07:01:35\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-03 10:36:13\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 17:42:11\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 18:40:48\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.4.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-29 21:13:08\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 18:40:24\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-02 18:36:15\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-07 09:06:21\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-01 13:08:30\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-08-28 15:58:51\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-25 14:09:36\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-22 02:53:03\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-27 22:57:29\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-24 12:26:36\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-09-20 08:57:43\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 11:37:23\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-30 13:46:36\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-17 16:42:42\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.3.3\";s:7:\"updated\";s:19:\"2024-02-04 02:42:53\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.3.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.15/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.20/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-05 10:16:58\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-02 23:17:46\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-12 23:13:21\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-20 15:18:28\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 09:46:35\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-05 10:15:01\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-29 13:35:45\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.4/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-02 23:37:18\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-08-09 07:20:47\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.32\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.32/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-05-28 22:06:16\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-06 03:44:24\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-05 12:01:28\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 09:00:55\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-16 00:18:25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-06 22:35:57\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 16:37:11\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.3.3\";s:7:\"updated\";s:19:\"2024-02-06 11:15:48\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.3.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.25/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.20/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.5\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.5/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-19 07:05:28\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-30 22:17:03\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-21 15:26:43\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.5\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-09-01 07:05:22\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.7/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-27 12:11:59\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-05 01:27:19\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.25/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.14\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.14/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-30 01:53:30\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-03 10:23:44\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-14 13:34:08\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-04 12:07:43\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-09 06:56:05\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-06 10:01:18\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.33\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.33/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-08-21 12:17:05\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-08 00:25:54\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-07 09:07:54\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-07 09:12:03\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.4.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-02 19:33:16\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-02 16:10:47\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.15/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-20 13:34:53\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-12 10:29:16\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-10-27 05:49:48\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-13 18:56:56\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2024-01-05 19:26:05\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-05 20:17:38\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.17\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.17/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.9/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.24/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-06 16:42:19\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-12-04 04:55:01\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.1.5\";s:7:\"updated\";s:19:\"2023-03-04 10:46:30\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.15/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-07-15 15:30:50\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.4/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-10 16:50:00\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.4.1\";s:7:\"updated\";s:19:\"2023-11-23 09:22:54\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `jx_options` VALUES("1912", "_site_transient_timeout_theme_roots", "1707232140", "no");
INSERT INTO `jx_options` VALUES("1913", "_site_transient_theme_roots", "a:2:{s:4:\"Divi\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";}", "no");
INSERT INTO `jx_options` VALUES("1926", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/es_ES/wordpress-6.4.3.zip\";s:6:\"locale\";s:5:\"es_ES\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/es_ES/wordpress-6.4.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.4.3\";s:7:\"version\";s:5:\"6.4.3\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1707230354;s:15:\"version_checked\";s:5:\"6.4.3\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `jx_options` VALUES("1927", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1707230355;s:7:\"checked\";a:2:{s:4:\"Divi\";s:6:\"4.23.1\";s:16:\"twentytwentyfour\";s:3:\"1.0\";}s:8:\"response\";a:1:{s:4:\"Divi\";a:4:{s:11:\"new_version\";s:4:\"4.24\";s:5:\"theme\";s:4:\"Divi\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:148:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=e905dacdf3a0cdce7400be4c4138ac9af2f36d4e&username=CAPTABILIDADES\";}}s:9:\"no_update\";a:1:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.0.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `jx_options` VALUES("1928", "_site_transient_et_update_themes", "O:8:\"stdClass\":3:{s:7:\"checked\";a:2:{s:4:\"Divi\";s:6:\"4.23.1\";s:16:\"twentytwentyfour\";s:3:\"1.0\";}s:8:\"response\";a:1:{s:4:\"Divi\";a:4:{s:11:\"new_version\";s:4:\"4.24\";s:5:\"theme\";s:4:\"Divi\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:148:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=e905dacdf3a0cdce7400be4c4138ac9af2f36d4e&username=CAPTABILIDADES\";}}s:12:\"last_checked\";i:1707230355;}", "no");
INSERT INTO `jx_options` VALUES("1929", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1707230359;s:8:\"response\";a:4:{s:35:\"cookie-law-info/cookie-law-info.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:29:\"w.org/plugins/cookie-law-info\";s:4:\"slug\";s:15:\"cookie-law-info\";s:6:\"plugin\";s:35:\"cookie-law-info/cookie-law-info.php\";s:11:\"new_version\";s:5:\"3.1.8\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/cookie-law-info/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/cookie-law-info.3.1.8.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:60:\"https://ps.w.org/cookie-law-info/assets/icon.svg?rev=3007243\";s:3:\"svg\";s:60:\"https://ps.w.org/cookie-law-info/assets/icon.svg?rev=3007243\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/cookie-law-info/assets/banner-1544x500.jpg?rev=3007243\";s:2:\"1x\";s:70:\"https://ps.w.org/cookie-law-info/assets/banner-772x250.jpg?rev=3007243\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"5.0.0\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:3:\"5.6\";s:14:\"upgrade_notice\";s:144:\"<p>[Add] - Option to choose sidebar for preference center layout.\n[Add] - Option to show categories on first layer.\n[Fix] - Minor bug fixes.</p>\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.5.8\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.5.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:6:\"5.6.20\";}s:35:\"addons-for-divi/addons-for-divi.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:29:\"w.org/plugins/addons-for-divi\";s:4:\"slug\";s:15:\"addons-for-divi\";s:6:\"plugin\";s:35:\"addons-for-divi/addons-for-divi.php\";s:11:\"new_version\";s:5:\"3.6.6\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/addons-for-divi/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/addons-for-divi.3.6.6.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:60:\"https://ps.w.org/addons-for-divi/assets/icon.svg?rev=2981263\";s:3:\"svg\";s:60:\"https://ps.w.org/addons-for-divi/assets/icon.svg?rev=2981263\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/addons-for-divi/assets/banner-1544x500.png?rev=2981263\";s:2:\"1x\";s:70:\"https://ps.w.org/addons-for-divi/assets/banner-772x250.png?rev=2981263\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:3:\"7.0\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"22.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"6.3\";s:6:\"tested\";s:5:\"6.4.3\";s:12:\"requires_php\";s:5:\"7.2.5\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:27:\"maintenance/maintenance.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/maintenance\";s:4:\"slug\";s:11:\"maintenance\";s:6:\"plugin\";s:27:\"maintenance/maintenance.php\";s:11:\"new_version\";s:4:\"4.08\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/maintenance/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/maintenance.4.08.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/maintenance/assets/icon-256x256.png?rev=2689583\";s:2:\"1x\";s:64:\"https://ps.w.org/maintenance/assets/icon-128x128.png?rev=2689583\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/maintenance/assets/banner-772x250.png?rev=1637471\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:26:\"popups-for-divi/plugin.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/popups-for-divi\";s:4:\"slug\";s:15:\"popups-for-divi\";s:6:\"plugin\";s:26:\"popups-for-divi/plugin.php\";s:11:\"new_version\";s:5:\"3.0.5\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/popups-for-divi/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/popups-for-divi.3.0.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/popups-for-divi/assets/icon-256x256.jpg?rev=2553226\";s:2:\"1x\";s:68:\"https://ps.w.org/popups-for-divi/assets/icon-128x128.jpg?rev=2553226\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/popups-for-divi/assets/banner-1544x500.jpg?rev=2553226\";s:2:\"1x\";s:70:\"https://ps.w.org/popups-for-divi/assets/banner-772x250.jpg?rev=2553226\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.0.0\";}s:19:\"404page/404page.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/404page\";s:4:\"slug\";s:7:\"404page\";s:6:\"plugin\";s:19:\"404page/404page.php\";s:11:\"new_version\";s:6:\"11.4.4\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/404page/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/404page.11.4.4.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:52:\"https://ps.w.org/404page/assets/icon.svg?rev=2451324\";s:3:\"svg\";s:52:\"https://ps.w.org/404page/assets/icon.svg?rev=2451324\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/supreme-modules-for-divi\";s:4:\"slug\";s:24:\"supreme-modules-for-divi\";s:6:\"plugin\";s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";s:11:\"new_version\";s:5:\"2.5.3\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/supreme-modules-for-divi/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/supreme-modules-for-divi.2.5.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/supreme-modules-for-divi/assets/icon-256x256.png?rev=2329163\";s:2:\"1x\";s:77:\"https://ps.w.org/supreme-modules-for-divi/assets/icon-128x128.png?rev=2329163\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/supreme-modules-for-divi/assets/banner-1544x500.png?rev=2878592\";s:2:\"1x\";s:79:\"https://ps.w.org/supreme-modules-for-divi/assets/banner-772x250.png?rev=2878592\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.5\";}}s:7:\"checked\";a:12:{s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.3\";s:35:\"cookie-law-info/cookie-law-info.php\";s:5:\"3.1.7\";s:33:\"divi-mega-menu/divi-mega-menu.php\";s:3:\"3.5\";s:25:\"duplicator/duplicator.php\";s:7:\"1.5.7.1\";s:27:\"maintenance/maintenance.php\";s:4:\"4.08\";s:26:\"popups-for-divi/plugin.php\";s:5:\"3.0.5\";s:19:\"404page/404page.php\";s:6:\"11.4.4\";s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";s:5:\"2.5.3\";s:35:\"addons-for-divi/addons-for-divi.php\";s:5:\"3.6.5\";s:23:\"wp-rocket/wp-rocket.php\";s:6:\"3.15.4\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"21.5\";s:40:\"wordpress-seo-premium/wp-seo-premium.php\";s:4:\"19.7\";}}", "no");
INSERT INTO `jx_options` VALUES("1930", "_site_transient_et_update_all_plugins", "O:8:\"stdClass\":3:{s:7:\"checked\";a:12:{s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.3\";s:35:\"cookie-law-info/cookie-law-info.php\";s:5:\"3.1.7\";s:33:\"divi-mega-menu/divi-mega-menu.php\";s:3:\"3.5\";s:25:\"duplicator/duplicator.php\";s:7:\"1.5.7.1\";s:27:\"maintenance/maintenance.php\";s:4:\"4.08\";s:26:\"popups-for-divi/plugin.php\";s:5:\"3.0.5\";s:19:\"404page/404page.php\";s:6:\"11.4.4\";s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";s:5:\"2.5.3\";s:35:\"addons-for-divi/addons-for-divi.php\";s:5:\"3.6.5\";s:23:\"wp-rocket/wp-rocket.php\";s:6:\"3.15.4\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"21.5\";s:40:\"wordpress-seo-premium/wp-seo-premium.php\";s:4:\"19.7\";}s:8:\"response\";a:0:{}s:12:\"last_checked\";i:1707230359;}", "no");
INSERT INTO `jx_options` VALUES("1931", "_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271", "1707835161", "no");
INSERT INTO `jx_options` VALUES("1932", "_site_transient_php_check_38979a08dcd71638878b7b4419751271", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `jx_options` VALUES("1933", "_transient_timeout_et_core_path", "1707316763", "no");
INSERT INTO `jx_options` VALUES("1934", "_transient_et_core_path", "/home/cursopowerbidayd/public_html/wp-content/themes/Divi/core", "no");
INSERT INTO `jx_options` VALUES("1935", "_transient_timeout_et_core_version", "1707316763", "no");
INSERT INTO `jx_options` VALUES("1936", "_transient_et_core_version", "4.23.1", "no");
INSERT INTO `jx_options` VALUES("1937", "_transient_timeout_et_check_mod_pagespeed", "1707316764", "no");
INSERT INTO `jx_options` VALUES("1938", "_transient_et_check_mod_pagespeed", "", "no");
INSERT INTO `jx_options` VALUES("1939", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":4,\"critical\":2}", "yes");
INSERT INTO `jx_options` VALUES("1940", "_et_builder_da_feature_cache", "a:2:{i:0;s:39:\"{\"gph\":-1,\"divi\":\"4.23.1\",\"wp\":\"6.4.3\"}\";i:1;a:1:{s:8:\"notfound\";a:2:{s:29:\"_et_dynamic_cached_shortcodes\";a:0:{}s:29:\"_et_dynamic_cached_attributes\";a:0:{}}}}", "yes");
INSERT INTO `jx_options` VALUES("1942", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"XFC0L9fxRSGKY-.U3RV6X=T25z6;&g0QnA7pFxzJH-Zy\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 177.349999999999994315658113919198513031005859375,\n    \"siteNumFiles\": 10450,\n    \"siteDbSizeMB\": 1.5500000000000000444089209850062616169452667236328125,\n    \"siteDbNumTables\": 25\n}", "yes");

/* INSERT TABLE DATA: jx_postmeta */
INSERT INTO `jx_postmeta` VALUES("23", "14", "_edit_last", "1");
INSERT INTO `jx_postmeta` VALUES("24", "14", "_edit_lock", "1678981197:1");
INSERT INTO `jx_postmeta` VALUES("25", "14", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("26", "14", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("27", "14", "_et_pb_page_layout", "et_no_sidebar");
INSERT INTO `jx_postmeta` VALUES("28", "14", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("29", "14", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("30", "14", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("31", "14", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("32", "14", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("33", "14", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("34", "14", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("35", "14", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("36", "14", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("37", "14", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"14\" /]");
INSERT INTO `jx_postmeta` VALUES("38", "14", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("39", "14", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("41", "14", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("42", "14", "_et_builder_version", "VB|Divi|4.20.2");
INSERT INTO `jx_postmeta` VALUES("43", "14", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("44", "14", "_thumbnail_id", "0");
INSERT INTO `jx_postmeta` VALUES("47", "19", "_edit_last", "1");
INSERT INTO `jx_postmeta` VALUES("48", "19", "_edit_lock", "1678981240:1");
INSERT INTO `jx_postmeta` VALUES("49", "19", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("50", "19", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("51", "19", "_et_pb_page_layout", "et_no_sidebar");
INSERT INTO `jx_postmeta` VALUES("52", "19", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("53", "19", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("54", "19", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("55", "19", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("56", "19", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("57", "19", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("58", "19", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("59", "19", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("60", "19", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("61", "19", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"19\" /]");
INSERT INTO `jx_postmeta` VALUES("62", "19", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("63", "19", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("65", "19", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("66", "19", "_et_builder_version", "VB|Divi|4.20.2");
INSERT INTO `jx_postmeta` VALUES("67", "19", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("68", "23", "_edit_last", "1");
INSERT INTO `jx_postmeta` VALUES("69", "23", "_edit_lock", "1678981278:1");
INSERT INTO `jx_postmeta` VALUES("70", "23", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("71", "23", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("72", "23", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `jx_postmeta` VALUES("73", "23", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("74", "23", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("75", "23", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("76", "23", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("77", "23", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("78", "23", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("79", "23", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("80", "23", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("81", "23", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("82", "23", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"23\" /]");
INSERT INTO `jx_postmeta` VALUES("83", "23", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("84", "23", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("86", "23", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("87", "23", "_et_builder_version", "VB|Divi|4.20.2");
INSERT INTO `jx_postmeta` VALUES("88", "23", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("91", "14", "_wp_desired_post_slug", "politica-de-cookies");
INSERT INTO `jx_postmeta` VALUES("94", "19", "_wp_desired_post_slug", "politica-de-privacidad");
INSERT INTO `jx_postmeta` VALUES("97", "23", "_wp_desired_post_slug", "aviso-legal");
INSERT INTO `jx_postmeta` VALUES("108", "42", "_wp_attached_file", "2023/09/marketing-bg6.png");
INSERT INTO `jx_postmeta` VALUES("109", "42", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1345;s:4:\"file\";s:25:\"2023/09/marketing-bg6.png\";s:8:\"filesize\";i:91483;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-300x158.png\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9031;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"marketing-bg6-1024x538.png\";s:5:\"width\";i:1024;s:6:\"height\";i:538;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:36591;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3668;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-768x404.png\";s:5:\"width\";i:768;s:6:\"height\";i:404;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28359;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:26:\"marketing-bg6-1536x807.png\";s:5:\"width\";i:1536;s:6:\"height\";i:807;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:63993;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:27:\"marketing-bg6-2048x1076.png\";s:5:\"width\";i:2048;s:6:\"height\";i:1076;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:108541;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12537;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:26:\"marketing-bg6-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:43371;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12969;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17202;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:26:\"marketing-bg6-1080x567.png\";s:5:\"width\";i:1080;s:6:\"height\";i:567;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45170;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12973;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:26:\"marketing-bg6-1280x673.png\";s:5:\"width\";i:1280;s:6:\"height\";i:673;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:49434;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-980x515.png\";s:5:\"width\";i:980;s:6:\"height\";i:515;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39247;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:25:\"marketing-bg6-480x252.png\";s:5:\"width\";i:480;s:6:\"height\";i:252;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15197;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("110", "43", "_wp_attached_file", "2023/09/phones-diagonal-1.png");
INSERT INTO `jx_postmeta` VALUES("111", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:930;s:4:\"file\";s:29:\"2023/09/phones-diagonal-1.png\";s:8:\"filesize\";i:279905;s:5:\"sizes\";a:10:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-300x279.png\";s:5:\"width\";i:300;s:6:\"height\";i:279;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:59044;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:23772;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-768x714.png\";s:5:\"width\";i:768;s:6:\"height\";i:714;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:279145;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:75531;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:30:\"phones-diagonal-1-1000x675.png\";s:5:\"width\";i:1000;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:336272;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:83398;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:128860;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:140212;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-980x911.png\";s:5:\"width\";i:980;s:6:\"height\";i:911;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:405428;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:29:\"phones-diagonal-1-480x446.png\";s:5:\"width\";i:480;s:6:\"height\";i:446;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:124953;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("112", "44", "_wp_attached_file", "2023/09/laptop-analytics-2.png");
INSERT INTO `jx_postmeta` VALUES("113", "44", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1500;s:6:\"height\";i:913;s:4:\"file\";s:30:\"2023/09/laptop-analytics-2.png\";s:8:\"filesize\";i:251826;s:5:\"sizes\";a:13:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-300x183.png\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22212;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"laptop-analytics-2-1024x623.png\";s:5:\"width\";i:1024;s:6:\"height\";i:623;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:152505;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10101;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-768x467.png\";s:5:\"width\";i:768;s:6:\"height\";i:467;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:93378;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35266;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:31:\"laptop-analytics-2-1080x675.png\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:176937;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38205;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:58550;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:31:\"laptop-analytics-2-1080x657.png\";s:5:\"width\";i:1080;s:6:\"height\";i:657;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:171055;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:50577;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:31:\"laptop-analytics-2-1280x779.png\";s:5:\"width\";i:1280;s:6:\"height\";i:779;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:226776;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-980x596.png\";s:5:\"width\";i:980;s:6:\"height\";i:596;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:140391;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:30:\"laptop-analytics-2-480x292.png\";s:5:\"width\";i:480;s:6:\"height\";i:292;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:44389;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("114", "1738", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("115", "1735", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("116", "1733", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("117", "1733", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("118", "1733", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("119", "1733", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"1733\" /]");
INSERT INTO `jx_postmeta` VALUES("120", "1733", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("121", "1733", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("122", "1733", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("123", "1733", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("124", "1733", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("125", "1733", "_et_builder_version", "VB|Divi|4.8.1");
INSERT INTO `jx_postmeta` VALUES("126", "1733", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("127", "1733", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("128", "1733", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("129", "895", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("130", "895", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("131", "895", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("132", "895", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"895\" /]");
INSERT INTO `jx_postmeta` VALUES("133", "895", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("134", "895", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("135", "895", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("136", "895", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("137", "895", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("138", "895", "_et_pb_product_page_layout", "et_build_from_scratch");
INSERT INTO `jx_postmeta` VALUES("139", "895", "_et_builder_version", "VB|Divi|4.8.2");
INSERT INTO `jx_postmeta` VALUES("140", "895", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("141", "895", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("142", "895", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("143", "1739", "_wp_attached_file", "2023/09/feature-img-2-2-300x242-1.jpg");
INSERT INTO `jx_postmeta` VALUES("144", "1739", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:658;s:6:\"height\";i:530;s:4:\"file\";s:37:\"2023/09/feature-img-2-2-300x242-1.jpg\";s:8:\"filesize\";i:53191;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-300x242.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:242;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8985;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4555;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11394;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12300;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17030;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15320;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:37:\"feature-img-2-2-300x242-1-480x387.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:387;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16155;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("145", "1740", "_wp_attached_file", "2023/09/feature-img-1-2-300x242-1.jpg");
INSERT INTO `jx_postmeta` VALUES("146", "1740", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:658;s:6:\"height\";i:530;s:4:\"file\";s:37:\"2023/09/feature-img-1-2-300x242-1.jpg\";s:8:\"filesize\";i:47982;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-300x242.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:242;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7848;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4395;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8891;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10149;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14116;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:17957;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:37:\"feature-img-1-2-300x242-1-480x387.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:387;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14007;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("147", "1741", "_wp_attached_file", "2023/09/5.jpg");
INSERT INTO `jx_postmeta` VALUES("148", "1741", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:640;s:6:\"height\";i:959;s:4:\"file\";s:13:\"2023/09/5.jpg\";s:8:\"filesize\";i:84609;s:5:\"sizes\";a:8:{s:6:\"medium\";a:5:{s:4:\"file\";s:13:\"5-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12761;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:13:\"5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6569;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:13:\"5-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16208;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:13:\"5-640x675.jpg\";s:5:\"width\";i:640;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:60798;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:13:\"5-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18719;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:13:\"5-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28406;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:13:\"5-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31972;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:13:\"5-480x719.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:719;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:45626;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("149", "1742", "_wp_attached_file", "2023/09/geometric-bg-overlay-01.jpg");
INSERT INTO `jx_postmeta` VALUES("150", "1742", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:800;s:4:\"file\";s:35:\"2023/09/geometric-bg-overlay-01.jpg\";s:8:\"filesize\";i:35083;s:5:\"sizes\";a:14:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-300x125.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:125;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1683;}s:5:\"large\";a:5:{s:4:\"file\";s:36:\"geometric-bg-overlay-01-1024x427.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:427;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8942;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1293;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-768x320.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5665;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:36:\"geometric-bg-overlay-01-1536x640.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18061;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2809;}s:31:\"et-pb-post-main-image-fullwidth\";a:5:{s:4:\"file\";s:36:\"geometric-bg-overlay-01-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13778;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3051;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4344;}s:28:\"et-pb-portfolio-image-single\";a:5:{s:4:\"file\";s:36:\"geometric-bg-overlay-01-1080x450.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:450;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10076;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4520;}s:32:\"et-pb-image--responsive--desktop\";a:5:{s:4:\"file\";s:36:\"geometric-bg-overlay-01-1280x533.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:533;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13482;}s:31:\"et-pb-image--responsive--tablet\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-980x408.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:408;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8580;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:35:\"geometric-bg-overlay-01-480x200.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2885;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jx_postmeta` VALUES("151", "290", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("152", "289", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("153", "288", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("154", "287", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("156", "286", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("157", "285", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("158", "284", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("159", "283", "_et_pb_built_for_post_type", "dmmenu");
INSERT INTO `jx_postmeta` VALUES("164", "1747", "_edit_last", "8");
INSERT INTO `jx_postmeta` VALUES("165", "1747", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("166", "1747", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("167", "1747", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `jx_postmeta` VALUES("168", "1747", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("169", "1747", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("170", "1747", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("171", "1747", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("172", "1747", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("173", "1747", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("174", "1747", "_edit_lock", "1700491920:8");
INSERT INTO `jx_postmeta` VALUES("177", "1747", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("180", "1747", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("181", "1747", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("182", "1747", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("183", "1747", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"1747\" /]");
INSERT INTO `jx_postmeta` VALUES("184", "1747", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("185", "1747", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("186", "1747", "_thumbnail_id", "0");
INSERT INTO `jx_postmeta` VALUES("187", "1747", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("188", "1747", "_et_builder_version", "VB|Divi|4.23.1");
INSERT INTO `jx_postmeta` VALUES("191", "1751", "_edit_last", "8");
INSERT INTO `jx_postmeta` VALUES("192", "1751", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("193", "1751", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("194", "1751", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `jx_postmeta` VALUES("195", "1751", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("196", "1751", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("197", "1751", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("198", "1751", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("199", "1751", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("200", "1751", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("201", "1751", "_edit_lock", "1700492039:8");
INSERT INTO `jx_postmeta` VALUES("204", "1751", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("207", "1751", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("208", "1751", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("209", "1751", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("210", "1751", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"1751\" /]");
INSERT INTO `jx_postmeta` VALUES("211", "1751", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("212", "1751", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("213", "1751", "_thumbnail_id", "0");
INSERT INTO `jx_postmeta` VALUES("214", "1751", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("215", "1751", "_et_builder_version", "VB|Divi|4.23.1");
INSERT INTO `jx_postmeta` VALUES("218", "1755", "_edit_last", "8");
INSERT INTO `jx_postmeta` VALUES("219", "1755", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("220", "1755", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("221", "1755", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `jx_postmeta` VALUES("222", "1755", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("223", "1755", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("224", "1755", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("225", "1755", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("226", "1755", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("227", "1755", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("228", "1755", "_edit_lock", "1700492084:8");
INSERT INTO `jx_postmeta` VALUES("231", "1755", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("234", "1755", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("235", "1755", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("236", "1755", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("237", "1755", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"1755\" /]");
INSERT INTO `jx_postmeta` VALUES("238", "1755", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("239", "1755", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("240", "1755", "_thumbnail_id", "0");
INSERT INTO `jx_postmeta` VALUES("241", "1755", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("242", "1755", "_et_builder_version", "VB|Divi|4.23.1");
INSERT INTO `jx_postmeta` VALUES("245", "1759", "_edit_last", "8");
INSERT INTO `jx_postmeta` VALUES("246", "1759", "_edit_lock", "1700492274:8");
INSERT INTO `jx_postmeta` VALUES("247", "1759", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("248", "1759", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("249", "1759", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("250", "1759", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("251", "1759", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("252", "1759", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("253", "1759", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"1759\" /]");
INSERT INTO `jx_postmeta` VALUES("254", "1759", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("255", "1759", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("256", "1759", "_thumbnail_id", "0");
INSERT INTO `jx_postmeta` VALUES("257", "1759", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("258", "1759", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("259", "1759", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("260", "1759", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("261", "1759", "_et_builder_version", "VB|Divi|4.23.1");
INSERT INTO `jx_postmeta` VALUES("264", "1762", "_edit_last", "8");
INSERT INTO `jx_postmeta` VALUES("265", "1762", "_wp_page_template", "default");
INSERT INTO `jx_postmeta` VALUES("266", "1762", "_et_pb_post_hide_nav", "default");
INSERT INTO `jx_postmeta` VALUES("267", "1762", "_et_pb_page_layout", "et_right_sidebar");
INSERT INTO `jx_postmeta` VALUES("268", "1762", "_et_pb_side_nav", "off");
INSERT INTO `jx_postmeta` VALUES("269", "1762", "_et_pb_use_builder", "on");
INSERT INTO `jx_postmeta` VALUES("270", "1762", "_et_pb_first_image", "");
INSERT INTO `jx_postmeta` VALUES("271", "1762", "_et_pb_truncate_post", "");
INSERT INTO `jx_postmeta` VALUES("272", "1762", "_et_pb_truncate_post_date", "");
INSERT INTO `jx_postmeta` VALUES("273", "1762", "_et_pb_old_content", "");
INSERT INTO `jx_postmeta` VALUES("274", "1762", "_edit_lock", "1700492223:8");
INSERT INTO `jx_postmeta` VALUES("277", "1762", "_et_pb_show_page_creation", "off");
INSERT INTO `jx_postmeta` VALUES("280", "1762", "_et_pb_built_for_post_type", "page");
INSERT INTO `jx_postmeta` VALUES("281", "1762", "_et_pb_ab_subjects", "");
INSERT INTO `jx_postmeta` VALUES("282", "1762", "_et_pb_enable_shortcode_tracking", "");
INSERT INTO `jx_postmeta` VALUES("283", "1762", "_et_pb_ab_current_shortcode", "[et_pb_split_track id=\"1762\" /]");
INSERT INTO `jx_postmeta` VALUES("284", "1762", "_et_pb_custom_css", "");
INSERT INTO `jx_postmeta` VALUES("285", "1762", "_et_pb_gutter_width", "3");
INSERT INTO `jx_postmeta` VALUES("286", "1762", "_thumbnail_id", "0");
INSERT INTO `jx_postmeta` VALUES("287", "1762", "_global_colors_info", "{}");
INSERT INTO `jx_postmeta` VALUES("288", "1762", "_et_builder_version", "VB|Divi|4.23.1");

/* INSERT TABLE DATA: jx_posts */
INSERT INTO `jx_posts` VALUES("8", "1", "2023-03-15 20:10:52", "2023-03-15 20:10:52", "{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-twentytwentythree", "", "", "2023-03-15 20:10:52", "2023-03-15 20:10:52", "", "0", "http://cursopowerbi-dayde.es/2023/03/15/wp-global-styles-twentytwentythree/", "0", "wp_global_styles", "", "0");
INSERT INTO `jx_posts` VALUES("14", "1", "2023-03-16 16:41:05", "2023-03-16 15:41:05", "[et_pb_section fb_built=\"1\" _builder_version=\"4.20.2\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_row _builder_version=\"4.20.2\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.20.2\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.20.2\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"]<h1><strong>Política de Cookies</strong></h1>\n<p>&nbsp;</p>\n<ol>\n<li>\n<h3>Cookies</h3>\n<h3><strong> </strong></h3>\n<p>1.1. XXXXXXXXXX , le informa que presente sitio web: www..com (en adelante, el “Sitio Web”) utiliza cookies que ayudan a optimizar su visita. Si continúa navegando en este Sitio Web, consideramos que acepta su uso.</p>\n<p>1.2. Una cookie es un fichero que se descarga en su ordenador al acceder a determinadas páginas web. Las cookies permiten a un sitio web, entre otras cosas, almacenar y recuperar información sobre los hábitos de navegación de un usuario o de su equipo y, dependiendo de la información que contengan y de la forma en que utilice su equipo, pueden utilizarse para reconocer al usuario.</p>\n<p>1.3. XXXXXXXXXXXX tiene la obligación por el Real Decreto-ley 13/2012 que modifica la Ley 34/2002, de 11 de julio, de Servicios de la Sociedad de la Información y de Comercio Electrónico, de informar y obtener el consentimiento del usuario acerca del uso de las cookies en este Sitio Web.</p>\n</li>\n<li>\n<h3>Tipos de cookies<strong><br /></strong></h3>\n<p>2.1. Según quien sea la entidad que gestione el dominio desde donde se envían las cookies y trate los datos que se obtengan se pueden distinguir dos tipos: cookies propias y cookies de terceros.</p>\n<p>2.2. Existe también una segunda clasificación según el plazo de tiempo que permanecen almacenadas en el navegador del cliente, pudiendo tratarse de cookies de sesión o cookies persistentes.</p>\n<p>2.3. Por último, existe otra clasificación con cinco tipos de cookies según la finalidad para la que se traten los datos obtenidos: cookies técnicas, cookies de personalización, cookies de análisis, cookies publicitarias y cookies de publicidad comportamental.</p>\n</li>\n<li>\n<h3>Cookies utilizadas en este Sitio Web<strong><br /></strong></h3>\n<p>3.1. XXXXXXXXXXXX utiliza las siguientes cookies analíticas:</p>\n<ul>\n<li>ac_cookies: cookie técnica y estrictamente necesaria que contiene el valor de si se ha aceptado la instalación de cookies. Caduca en 1 año desde la última actualización.</li>\n<li>_ga: cookie de Google Analytics que habilita la función de control de visitas únicas. La primera vez que un usuario entre en el sitio web a través de un navegador se instalará esta cookie. Cuando este usuario vuelva a entrar en la web con el mismo navegador, la cookie considerará que es el mismo usuario. Solo en el caso de que el usuario cambie de navegador, se considerará otro usuario. Caduca a los 2 años desde la última actualización.</li>\n<li>_gat: Esta cookie se asocia con Google Analytics Universal. Se utiliza para limitar la velocidad de petición - la limitación de la recogida de datos en los sitios de alto tráfico. Caduca a los 10 minutos.</li>\n<li>_utma: cookie de Google Analytics que registra la fecha de la primera y última vez que el usuario vistió el sitio web. Caduca a los 2 años desde la última actualización.</li>\n<li>_utmb: cookie de Google Analytics que registra la hora de llegada a la página web. Caduca a los 30 minutos desde la última actualización.</li>\n<li>_utmc: cookie de Google Analytics utilizada para la interoperabilidad con el código de seguimiento urchin.js. Se elimina al cerrar el navegador.</li>\n<li>_utmt: cookie de Google Analytics. Esta cookie se utiliza para procesar el tipo de solicitud pedida por el usuario. Caduca al finalizar la sesión.</li>\n<li>_utmv: cookie de Google Analytics. Esta cookie se utiliza para segmentar datos demográficos. Caduca al finalizar la sesión.</li>\n<li>_utmz: cookie de Google Analytics que almacena la fuente de tráfico o una campaña para explicar cómo el usuario llegó al sitio web. Caduca a los 6 meses desde la última actualización.</li>\n</ul>\n<p>Puede encontrar más información al respecto e inhabilitar el uso de estas cookies pulsando <a href=\"https://developers.google.com/analytics/devguides/collection/analyticsjs/cookie-usage?hl=es#analyticsjs\">aquí</a>.</p>\n<p>3.2. A través de la analítica web no se obtiene información sobre los datos personales de los usuarios, garantizando la tutela de su privacidad. La información que se obtiene es la relativa al número de usuarios que acceden a la web, el número de páginas vistas, la frecuencia y repetición de las visitas, su duración, el navegador utilizado, el operador que presta el servicio, el idioma, el terminal que utiliza, o la ciudad a la que está asignada su dirección IP. Información que posibilita un mejor y más apropiado servicio por parte de este Sitio Web.</p>\n<p>3.3.  Además de las cookies analíticas referidas en el punto 3.2, este Sitio Web utiliza cookies técnicas que permiten al usuario la navegación a través del Sitio Web y la utilización de las diferentes opciones o servicios que en él existen como, por ejemplo, controlar el tráfico y la comunicación de datos, identificar la sesión, o acceder a secciones de acceso restringido. Las cookies técnicas son las siguientes:</p>\n<ul>\n<li>AUTH_KEY</li>\n<li>SECURE_AUTH_KEY</li>\n<li>LOGGED_IN_KEY</li>\n<li>NONCE_KEY</li>\n<li>comment_author</li>\n<li>comment_author_email</li>\n<li>comment_author_url</li>\n</ul>\n<p>3.4. Al acceder el usuario a las páginas o perfiles de XXXXXXXXXXXXXXX en las distintas redes sociales acepta el uso de cookies por parte de las mismas.</p>\n<p>3.5. Dadas las características de Internet, no siempre contamos con información de las cookies que colocan terceras partes a través de este Sitio Web. Por consiguiente, en caso de que se encuentre con este tipo de cookies en este Sitio Web y no estén aquí descritas, le rogamos que nos lo comunique. También puede ponerse en contacto directamente con el tercero para pedirle información sobre las cookies que coloca, la finalidad y la duración de la cookie, y cómo garantiza la privacidad del usuario.</p>\n</li>\n<li>\n<h3>Modificar la configuración de las cookies<strong><br /></strong></h3>\n<p>4.1. El usuario puede permitir, bloquear o eliminar las cookies instaladas en su equipo mediante la configuración de las opciones del navegador instalado en su equipo.</p>\n<p>4.2. Para más información sobre Internet Explorer pulse <a href=\"http://windows.microsoft.com/es-xl/internet-explorer/delete-manage-cookies#ie=%22ie-10%22\">aquí</a>.</p>\n<p>4.3. Para más información sobre FireFox pulse <a href=\"http://support.mozilla.org/es/kb/Borrar%20cookies\">aquí</a>.</p>\n<p>4.4. Para más información sobre Chrome pulse <a href=\"http://support.google.com/chrome/answer/95647?hl=%22es%22\">aquí</a>.</p>\n<p>4.5. Para más información sobre Safari pulse <a href=\"https://support.apple.com/es-es/HT201265\">aquí</a>.</p>\n</li>\n</ol>\n<p>&nbsp;</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Política de cookies", "", "trash", "closed", "closed", "", "politica-de-cookies__trashed", "", "", "2023-03-23 11:36:29", "2023-03-23 10:36:29", "", "0", "http://cursopowerbi-dayde.es/?page_id=14", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("19", "1", "2023-03-16 16:42:54", "2023-03-16 15:42:54", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.20.2\" _module_preset=\"default\"][et_pb_row _builder_version=\"4.20.2\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.20.2\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.20.2\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p>Política de Privacidad</p>\n<ol>\n<li>\n<h3>¿Quién es el responsable del tratamiento de sus datos?</h3>\n<p>XXXXXX XXXXXXXX XXXXXX<br />XXXXXXXXXX<br />info@xxxxxxxxxxxx</p>\n</li>\n<li>\n<h3>¿Con qué finalidad tratamos sus datos personales?</h3>\n<p>En XXXXXX XXXXXXXX XXXXXX tratamos la información que nos facilitan las personas interesadas con el fin de Realizar la gestión administrativa, contable y fiscal de los servicios solicitados, así como enviar comunicaciones comerciales sobre nuestros productos y servicios.</p>\n</li>\n<li>\n<h3>¿Por cuánto tiempo conservaremos sus datos?</h3>\n<p>Los datos se conservarán mientras el interesado no solicite su supresión, y en su caso, durante los años necesarios para cumplir con las obligaciones legales.</p>\n</li>\n<li>\n<h3>¿Cuál es la legitimación para el tratamiento de sus datos?</h3>\n<p>Le indicamos la base legal para el tratamiento de sus datos:</p>\n<ul>\n<li>Ejecución de un contrato: Prestación de los servicios solicitados</li>\n<li>Interés legítimo del Responsable: Envío de comunicaciones comerciales</li>\n</ul>\n</li>\n<li>\n<h3>¿A qué destinatarios se comunicarán sus datos?</h3>\n<p>Los datos se comunicarán a los siguientes destinatarios:</p>\n<ul>\n<li>Agencia Tributaria, con la finalidad de Cumplir con las obligaciones legales</li>\n<li>Entidades financieras, con la finalidad de Girar los recibos correspondientes</li>\n</ul>\n</li>\n<li>\n<h3>Transferencias de datos a terceros países</h3>\n<p>No están previstas transferencias de datos a terceros países.</p>\n</li>\n<li>\n<h3>¿Cuáles son sus derechos cuando nos facilita sus datos?</h3>\n<p>Cualquier persona tiene derecho a obtener confirmación sobre si en XXXXXX XXXXXXXX XXXXXX estamos tratando datos personales que les conciernan, o no.</p>\n<p>Las personas interesadas tienen derecho a acceder a sus datos personales, así como a solicitar la rectificación de los datos inexactos o, en su caso, solicitar su supresión cuando, entre otros motivos, los datos ya no sean necesarios para los fines que fueron recogidos.</p>\n<p>En determinadas circunstancias, los interesados podrán solicitar la limitación del tratamiento de sus datos, en cuyo caso únicamente los conservaremos para el ejercicio o la defensa de reclamaciones.</p>\n<p>En determinadas circunstancias y por motivos relacionados con su situación particular, los interesados podrán oponerse al tratamiento de sus datos. En este caso, XXXXXX XXXXXXXX XXXXXX dejará de tratar los datos, salvo por motivos legítimos imperiosos, o el ejercicio o la defensa de posibles reclamaciones.</p>\n<p>Podrá ejercitar materialmente sus derechos de la siguiente forma: dirigiéndose a la dirección del responsable del tratamiento</p>\n<p>Si ha otorgado su consentimiento para alguna finalidad concreta, tiene derecho a retirar el consentimiento otorgado en cualquier momento, sin que ello afecte a la licitud del tratamiento basado en el consentimiento previo a su retirada.</p>\n<p>En caso de que sienta vulnerados sus derechos en lo concerniente a la protección de sus datos personales, especialmente cuando no haya obtenido satisfacción en el ejercicio de sus derechos, puede presentar una reclamación ante la Autoridad de Control en materia de Protección de Datos competente a través de su sitio web: <a href=\"http://www.agpd.es/\">www.agpd.es</a>.</p>\n</li>\n<li>\n<h3>¿Cómo hemos obtenido sus datos?</h3>\n<p>Los datos personales que tratamos en XXXXXX XXXXXXXX XXXXXX proceden del propio interesado.</p>\n<p>Las categorías de datos que se tratan son:</p>\n<ul>\n<li>Datos identificativos</li>\n<li>Direcciones postales y electrónicas</li>\n<li>Información comercial</li>\n</ul>\n<p>No se tratan categorías especiales de datos personales (son aquellos datos que revelen el origen étnico o racial, las opiniones políticas, las convicciones religiosas o filosóficas, o la afiliación sindical, datos genéticos, datos biométricos dirigidos a identificar de manera unívoca a una persona física, datos relativos a la salud o datos relativos a la vida sexual o la orientación sexual de una persona física).</p>\n</li>\n</ol>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Política de Privacidad", "", "trash", "closed", "closed", "", "politica-de-privacidad__trashed", "", "", "2023-03-23 11:36:29", "2023-03-23 10:36:29", "", "0", "http://cursopowerbi-dayde.es/?page_id=19", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("23", "1", "2023-03-16 16:43:36", "2023-03-16 15:43:36", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.20.2\" _module_preset=\"default\"][et_pb_row _builder_version=\"4.20.2\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.20.2\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.20.2\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h1>Aviso Legal</h1>\n<ol start=\"2\">\n<li>\n<h3>Objeto</h3>\n<p>El presente aviso legal regula el uso y utilización del sitio web www.xxxxxxxxx.com, del que es titular XXXXXX XXXXXXXX XXXXXX<span class=\"s1\"> </span>(en adelante, EL PROPIETARIO DE LA WEB).</p>\n<p>La navegación por el sitio web de EL PROPIETARIO DE LA WEB le atribuye la condición de USUARIO del mismo y conlleva su aceptación plena y sin reservas de todas y cada una de las condiciones publicadas en este aviso legal, advirtiendo de que dichas condiciones podrán ser modificadas sin notificación previa por parte de EL PROPIETARIO DE LA WEB, en cuyo caso se procederá a su publicación y aviso con la máxima antelación posible.</p>\n<p>Por ello es recomendable leer atentamente su contenido en caso de desear acceder y hacer uso de la información y de los servicios ofrecidos desde este sitio web.</p>\n<p>El usuario además, se obliga a hacer un uso correcto del sitio web de conformidad con las leyes, la buena fe, el orden público, los usos del tráfico y el presente Aviso Legal, y responderá frente a EL PROPIETARIO DE LA WEB o frente a terceros, de cualesquiera daños y perjuicios que pudieran causarse como consecuencia del incumplimiento de dicha obligación.</p>\n<p>Cualquier utilización distinta a la autorizada está expresamente prohibida, pudiendo EL PROPIETARIO DE LA WEB denegar o retirar el acceso y su uso en cualquier momento.</p>\n</li>\n<li>\n<h3>Identificación</h3>\n<p>EL PROPIETARIO DE LA WEB, en cumplimiento de la Ley 34/2002, de 11 de julio, de Servicios de la Sociedad de la Información y de Comercio Electrónico, le informa de que:</p>\n<ul>\n<li>Su denominación social es: XXXXXX XXXXXXXX XXXXXX</li>\n<li>Su NIF es:XXXXXXXXXX</li>\n</ul>\n</li>\n</ol>\n<ol start=\"4\">\n<li>\n<h3>Comunicaciones</h3>\n<p>Para comunicarse con nosotros, ponemos a su disposición diferentes medios de contacto que detallamos a continuación:</p>\n<ul>\n<li>Email: info@XXXXXXXXXXX</li>\n</ul>\n<p>Todas las notificaciones y comunicaciones entre los usuarios y PROPIETARIO DE LA WEB se considerarán eficaces, a todos los efectos, cuando se realicen a través de cualquier medio de los detallados anteriormente.</p>\n</li>\n<li>\n<h3>Condiciones de acceso y utilización</h3>\n<p>El sitio web y sus servicios son de acceso libre y gratuito. No obstante, PROPIETARIO DE LA WEB puede condicionar la utilización de algunos de los servicios ofrecidos en su web a la previa cumplimentación del correspondiente formulario.</p>\n<p>El usuario garantiza la autenticidad y actualidad de todos aquellos datos que comunique a PROPIETARIO DE LA WEB y será el único responsable de las manifestaciones falsas o inexactas que realice.</p>\n<p>El usuario se compromete expresamente a hacer un uso adecuado de los contenidos y servicios de PROPIETARIO DE LA WEB y a no emplearlos para, entre otros:</p>\n<ol>\n<li>Difundir contenidos delictivos, violentos, pornográficos, racistas, xenófobos, ofensivos, de apología del terrorismo o, en general, contrarios a la ley o al orden público.</li>\n<li>Introducir en la red virus informáticos o realizar actuaciones susceptibles de alterar, estropear, interrumpir o generar errores o daños en los documentos electrónicos, datos o sistemas físicos y lógicos de PROPIETARIO DE LA WEB o de terceras personas; así como obstaculizar el acceso de otros usuarios al sitio web y a sus servicios mediante el consumo masivo de los recursos informáticos a través de los cuales PROPIETARIO DE LA WEB presta sus servicios.</li>\n<li>Intentar acceder a las cuentas de correo electrónico de otros usuarios o a áreas restringidas de los sistemas informáticos de PROPIETARIO DE LA WEB o de terceros y, en su caso, extraer información.</li>\n<li>Vulnerar los derechos de propiedad intelectual o industrial, así como violar la confidencialidad de la información de PROPIETARIO DE LA WEB o de terceros.</li>\n<li>Suplantar la identidad de cualquier otro usuario.</li>\n<li>Reproducir, copiar, distribuir, poner a disposición de, o cualquier otra forma de comunicación pública, transformar o modificar los contenidos, a menos que se cuente con la autorización del titular de los correspondientes derechos o ello resulte legalmente permitido.</li>\n<li>Recabar datos con finalidad publicitaria y de remitir publicidad de cualquier clase y comunicaciones con fines de venta u otras de naturaleza comercial sin que medie su previa solicitud o consentimiento.</li>\n</ol>\n<p>Todos los contenidos del sitio web, como textos, fotografías, gráficos, imágenes, iconos, tecnología, software, así como su diseño gráfico y códigos fuente, constituyen una obra cuya propiedad pertenece a PROPIETARIO DE LA WEB, sin que puedan entenderse cedidos al usuario ninguno de los derechos de explotación sobre los mismos más allá de lo estrictamente necesario para el correcto uso de la web.</p>\n<p>En definitiva, los usuarios que accedan a este sitio web pueden visualizar los contenidos y efectuar, en su caso, copias privadas autorizadas siempre que los elementos reproducidos no sean cedidos posteriormente a terceros, ni se instalen a servidores conectados a redes, ni sean objeto de ningún tipo de explotación.</p>\n<p>Asimismo, todas las marcas, nombres comerciales o signos distintivos de cualquier clase que aparecen en el sitio web son propiedad de PROPIETARIO DE LA WEB, sin que pueda entenderse que el uso o acceso al mismo atribuya al usuario derecho alguno sobre los mismos.</p>\n<p>La distribución, modificación, cesión o comunicación pública de los contenidos y cualquier otro acto que no haya sido expresamente autorizado por el titular de los derechos de explotación quedan prohibidos.</p>\n<p>El establecimiento de un hiperenlace no implica en ningún caso la existencia de relaciones entre PROPIETARIO DE LA WEB y el propietario del sitio web en la que se establezca, ni la aceptación y aprobación por parte de PROPIETARIO DE LA WEB de sus contenidos o servicios.</p>\n<p>PROPIETARIO DE LA WEB no se responsabiliza del uso que cada usuario le dé a los materiales puestos a disposición en este sitio web ni de las actuaciones que realice en base a los mismos.</p>\n</li>\n</ol>\n<ul>\n<li>\n<h4>EXCLUSIÓN DE GARANTÍAS Y DE RESPONSABILIDAD EN EL ACCESO Y LA UTILIZACIÓN</h4>\n<p>El contenido del presente sitio web es de carácter general y tiene una finalidad meramente informativa, sin que se garantice plenamente el acceso a todos los contenidos, ni su exhaustividad, corrección, vigencia o actualidad, ni su idoneidad o utilidad para un objetivo específico.</p>\n<p>PROPIETARIO DE LA WEB excluye, hasta donde permite el ordenamiento jurídico, cualquier responsabilidad por los daños y perjuicios de toda naturaleza derivados de:</p>\n<ol>\n<li>a) La imposibilidad de acceso al sitio web o la falta de veracidad, exactitud, exhaustividad y/o actualidad de los contenidos, así como la existencia de vicios y defectos de toda clase de los contenidos transmitidos, difundidos, almacenados, puestos a disposición, a los que se haya accedido a través del sitio web o de los servicios que se ofrecen.</li>\n<li>b) La presencia de virus o de otros elementos en los contenidos que puedan producir alteraciones en los sistemas informáticos, documentos electrónicos o datos de los usuarios.</li>\n<li>c) El incumplimiento de las leyes, la buena fe, el orden público, los usos del tráfico y el presente aviso legal como consecuencia del uso incorrecto del sitio web. En particular, y a modo ejemplificativo, PROPIETARIO DE LA WEB no se hace responsable de las actuaciones de terceros que vulneren derechos de propiedad intelectual e industrial, secretos empresariales, derechos al honor, a la intimidad personal y familiar y a la propia imagen, así como la normativa en materia de competencia desleal y publicidad ilícita.</li>\n</ol>\n<p>Asimismo, PROPIETARIO DE LA WEB declina cualquier responsabilidad respecto a la información que se halle fuera de esta web y no sea gestionada directamente por nuestro webmaster. La función de los links que aparecen en esta web es exclusivamente la de informar al usuario sobre la existencia de otras fuentes susceptibles de ampliar los contenidos que ofrece este sitio web. PROPIETARIO DE LA WEB no garantiza ni se responsabiliza del funcionamiento o accesibilidad de los sitios enlazados; ni sugiere, invita o recomienda la visita a los mismos, por lo que tampoco será responsable del resultado obtenido. PROPIETARIO DE LA WEB no se responsabiliza del establecimiento de hipervínculos por parte de terceros.</p>\n</li>\n<li>\n<h4>PROCEDIMIENTO EN CASO DE REALIZACIÓN DE ACTIVIDADES DE CARÁCTER ILÍCITO</h4>\n<p>En el caso de que cualquier usuario o un tercero considere que existen hechos o circunstancias que revelen el carácter ilícito de la utilización de cualquier contenido y/o de la realización de cualquier actividad en las páginas web incluidas o accesibles a través del sitio web, deberá enviar una notificación a PROPIETARIO DE LA WEB identificándose debidamente y especificando las supuestas infracciones.</p>\n</li>\n<li>\n<h4>PUBLICACIONES</h4>\n<p>La información administrativa facilitada a través del sitio web no sustituye la publicidad legal de las leyes, normativas, planes, disposiciones generales y actos que tengan que ser publicados formalmente a los diarios oficiales de las administraciones públicas, que constituyen el único instrumento que da fe de su autenticidad y contenido. La información disponible en este sitio web debe entenderse como una guía sin propósito de validez legal.</p>\n</li>\n</ul>\n<ol start=\"5\">\n<li>\n<h3>Legislación aplicable</h3>\n<p>Las condiciones presentes se regirán por la legislación española vigente.</p>\n<p>La lengua utilizada será el Castellano.</p>\n</li>\n</ol>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Aviso Legal", "", "trash", "closed", "closed", "", "aviso-legal__trashed", "", "", "2023-03-23 11:36:29", "2023-03-23 10:36:29", "", "0", "http://cursopowerbi-dayde.es/?page_id=23", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("27", "5", "2023-03-23 11:55:17", "2023-03-23 10:55:17", "", "Divi", "", "publish", "closed", "closed", "", "divi", "", "", "2023-09-20 09:44:57", "2023-09-20 07:44:57", "", "0", "http://cursopowerbi-dayde.es/divi/", "0", "custom_css", "", "0");
INSERT INTO `jx_posts` VALUES("40", "8", "2023-09-20 09:44:57", "2023-09-20 07:44:57", "", "Divi", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2023-09-20 09:44:57", "2023-09-20 07:44:57", "", "27", "http://cursopowerbi-dayde.es/?p=40", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("42", "8", "2023-09-20 09:48:19", "2023-09-20 07:48:19", "", "marketing-bg6", "", "inherit", "open", "closed", "", "marketing-bg6", "", "", "2023-09-20 09:48:19", "2023-09-20 07:48:19", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/marketing-bg6.png", "0", "attachment", "image/png", "0");
INSERT INTO `jx_posts` VALUES("43", "8", "2023-09-20 09:48:22", "2023-09-20 07:48:22", "", "phones-diagonal-1", "", "inherit", "open", "closed", "", "phones-diagonal-1", "", "", "2023-09-20 09:48:22", "2023-09-20 07:48:22", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/phones-diagonal-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `jx_posts` VALUES("44", "8", "2023-09-20 09:48:23", "2023-09-20 07:48:23", "", "laptop-analytics-2", "", "inherit", "open", "closed", "", "laptop-analytics-2", "", "", "2023-09-20 09:48:23", "2023-09-20 07:48:23", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/laptop-analytics-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `jx_posts` VALUES("283", "8", "2021-12-22 08:17:39", "2021-12-22 08:17:39", "[et_pb_section fb_built=\"1\" module_id=\"drop\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_4,1_4,1_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_4\" _builder_version=\"4.16\" custom_padding=\"40px|40px|40px|40px\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_image src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/feature-img-1-2-300x242-1.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"4.16\" hover_enabled=\"0\" always_center_on_mobile=\"on\" global_colors_info=\"{}\"][/et_pb_image][et_pb_text _builder_version=\"4.16\" custom_padding=\"20px||20px|\" hover_enabled=\"0\" global_colors_info=\"{}\"]Create a stunning Mega Menu for your website using the Divi Builder.\r[/et_pb_text][et_pb_button button_url=\"https://diviengine.com\" url_new_window=\"on\" button_text=\"GET IT NOW\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\" button_text_size__hover_enabled=\"off\" button_one_text_size__hover_enabled=\"off\" button_two_text_size__hover_enabled=\"off\" button_text_color__hover_enabled=\"off\" button_one_text_color__hover_enabled=\"off\" button_two_text_color__hover_enabled=\"off\" button_border_width__hover_enabled=\"off\" button_one_border_width__hover_enabled=\"off\" button_two_border_width__hover_enabled=\"off\" button_border_color__hover_enabled=\"off\" button_one_border_color__hover_enabled=\"off\" button_two_border_color__hover_enabled=\"off\" button_border_radius__hover_enabled=\"off\" button_one_border_radius__hover_enabled=\"off\" button_two_border_radius__hover_enabled=\"off\" button_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover_enabled=\"off\" button_bg_color__hover_enabled=\"off\" button_one_bg_color__hover_enabled=\"off\" button_two_bg_color__hover_enabled=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" custom_padding=\"40px|40px|40px|40px\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_image src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/feature-img-2-2-300x242-1.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"4.16\" hover_enabled=\"0\" always_center_on_mobile=\"on\" global_colors_info=\"{}\"][/et_pb_image][et_pb_text _builder_version=\"4.16\" custom_padding=\"20px||20px|\" hover_enabled=\"0\" global_colors_info=\"{}\"]It is as easy as creating a page, create the Divi Mega Menu, assign it to a menu item in the appearance settings and that\'s it!\r[/et_pb_text][et_pb_button button_url=\"https://diviengine.com\" url_new_window=\"on\" button_text=\"GET IT NOW\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\" button_text_size__hover_enabled=\"off\" button_one_text_size__hover_enabled=\"off\" button_two_text_size__hover_enabled=\"off\" button_text_color__hover_enabled=\"off\" button_one_text_color__hover_enabled=\"off\" button_two_text_color__hover_enabled=\"off\" button_border_width__hover_enabled=\"off\" button_one_border_width__hover_enabled=\"off\" button_two_border_width__hover_enabled=\"off\" button_border_color__hover_enabled=\"off\" button_one_border_color__hover_enabled=\"off\" button_two_border_color__hover_enabled=\"off\" button_border_radius__hover_enabled=\"off\" button_one_border_radius__hover_enabled=\"off\" button_two_border_radius__hover_enabled=\"off\" button_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover_enabled=\"off\" button_bg_color__hover_enabled=\"off\" button_one_bg_color__hover_enabled=\"off\" button_two_bg_color__hover_enabled=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" use_background_color_gradient=\"on\" background_color_gradient_direction=\"135deg\" background_color_gradient_stops=\"#53a0fd 0%|#4161d4 100%\" background_color_gradient_start=\"#53a0fd\" background_color_gradient_end=\"#4161d4\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/geometric-bg-overlay-01.jpg\" background_blend=\"overlay\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_code admin_label=\"CSS\" _builder_version=\"4.16\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\"]<style><!-- [et_pb_line_break_holder] -->.menulinks li {<!-- [et_pb_line_break_holder] -->list-style: none!important;<!-- [et_pb_line_break_holder] -->    padding: 1em 1.8em;<!-- [et_pb_line_break_holder] -->    margin-left: 0!important;<!-- [et_pb_line_break_holder] -->    color: #91a7b9;<!-- [et_pb_line_break_holder] -->    line-height: 1rem;<!-- [et_pb_line_break_holder] -->    border-bottom: 1px solid #ffffff14;<!-- [et_pb_line_break_holder] -->    margin-bottom: 0;<!-- [et_pb_line_break_holder] -->    letter-spacing: .5px;<!-- [et_pb_line_break_holder] -->}<!-- [et_pb_line_break_holder] --><!-- [et_pb_line_break_holder] -->.menulinks ul {<!-- [et_pb_line_break_holder] -->    padding: 0;<!-- [et_pb_line_break_holder] -->}<!-- [et_pb_line_break_holder] -->.menulinks a {color:#fff !important;}<!-- [et_pb_line_break_holder] --><!-- [et_pb_line_break_holder] -->.de-mega-menu .et_pb_section, .de-mega-menu .et_pb_row {padding: 0;    width: 100%;}<!-- [et_pb_line_break_holder] --></style>[/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" use_background_color_gradient=\"on\" background_color_gradient_direction=\"135deg\" background_color_gradient_stops=\"#53a0fd 0%|#4161d4 100%\" background_color_gradient_start=\"#53a0fd\" background_color_gradient_end=\"#4161d4\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text module_class=\"menulinks\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<ul>\r\n 	<li><a href=\"#\">Welcome Message</a></li>\r\n 	<li><a href=\"#\">Our Goal</a></li>\r\n 	<li><a href=\"#\">Mission &amp; Vision</a></li>\r\n 	<li><a href=\"#\">Philosophy</a></li>\r\n 	<li><a href=\"#\">Faculty Directory</a></li>\r\n 	<li><a href=\"#\">History</a></li>\r\n 	<li><a href=\"#\">Professional Development</a></li>\r\n 	<li><a href=\"#\">Campus &amp; Directions</a></li>\r\n 	<li><a href=\"#\">Facts &amp; Figures</a></li>\r\n 	<li><a href=\"#\">Board of Directors</a></li>\r\n 	<li><a href=\"#\">Latest News</a></li>\r\n 	<li><a href=\"#\">Recent Video</a></li>\r\n</ul>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - 4 Column", "", "publish", "closed", "closed", "", "dmm-4-column", "", "", "2021-12-22 08:17:39", "2021-12-22 08:17:39", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-4-column/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("284", "8", "2021-12-22 08:17:54", "2021-12-22 08:17:54", "[et_pb_section fb_built=\"1\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_4,1_4,1_4,1_4\" _builder_version=\"4.16\" custom_padding=\"30px|50px|30px|50px|true|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Gallery</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_text _builder_version=\"4.16\" text_font=\"|600|||||||\" text_font_size=\"16px\" custom_margin=\"||14px|||\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Gallery 1 </p>[/et_pb_text][et_pb_gallery gallery_ids=\"1741,233\" posts_number=\"4\" show_title_and_caption=\"off\" show_pagination=\"off\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style_image=\"preset3\" global_colors_info=\"{}\"][/et_pb_gallery][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Simple Image</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_text _builder_version=\"4.16\" text_font=\"|600|||||||\" text_font_size=\"16px\" custom_margin=\"||14px|||\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Image 1</p>[/et_pb_text][et_pb_image src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/5.jpg\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset3\" global_colors_info=\"{}\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Video Slider</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_text _builder_version=\"4.16\" text_font=\"|600|||||||\" text_font_size=\"16px\" custom_margin=\"||14px|||\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Awesome video </p>[/et_pb_text][et_pb_video_slider _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset3\" global_colors_info=\"{}\"][et_pb_video_slider_item src=\"https://www.youtube.com/watch?v=4EZlrLh261U&list=PL9My989q_-K_PGRz0IX18pIZ_BefahfTh\" _builder_version=\"4.0.6\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_video_slider_item][et_pb_video_slider_item src=\"https://www.youtube.com/watch?v=4EZlrLh261U&list=PL9My989q_-K_PGRz0IX18pIZ_BefahfTh\" _builder_version=\"4.0.6\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_video_slider_item][/et_pb_video_slider][et_pb_text _builder_version=\"4.16\" text_font=\"|600|||||||\" text_font_size=\"16px\" custom_margin=\"||9px|||\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Video 3</p>[/et_pb_text][et_pb_video src=\"https://www.youtube.com/watch?v=4EZlrLh261U&list=PL9My989q_-K_PGRz0IX18pIZ_BefahfTh\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset3\" global_colors_info=\"{}\"][/et_pb_video][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p> Video list</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_text _builder_version=\"4.16\" text_font=\"|600|||||||\" text_font_size=\"16px\" custom_margin=\"||14px|||\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Video 1 </p>[/et_pb_text][et_pb_video src=\"https://www.youtube.com/watch?v=4EZlrLh261U&list=PL9My989q_-K_PGRz0IX18pIZ_BefahfTh\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset3\" global_colors_info=\"{}\"][/et_pb_video][et_pb_text _builder_version=\"4.16\" text_font=\"|600|||||||\" text_font_size=\"16px\" custom_margin=\"||11px|||\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Video 2</p>[/et_pb_text][et_pb_video src=\"https://www.youtube.com/watch?v=4EZlrLh261U&list=PL9My989q_-K_PGRz0IX18pIZ_BefahfTh\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset3\" global_colors_info=\"{}\"][/et_pb_video][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - Media", "", "publish", "closed", "closed", "", "dmm-media", "", "", "2021-12-22 08:17:54", "2021-12-22 08:17:54", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-media/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("285", "8", "2021-12-22 08:18:04", "2021-12-22 08:18:04", "[et_pb_section fb_built=\"1\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_3,2_3\" _builder_version=\"4.16\" custom_padding=\"30px|50px|30px|50px|true|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_3\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Blog post</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_text _builder_version=\"4.16\" text_font=\"Arial||||||||\" text_font_size=\"16px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Latest Post</p>[/et_pb_text][et_pb_blog fullwidth=\"off\" posts_number=\"1\" show_pagination=\"off\" offset_number=\"0\" _builder_version=\"4.16\" hover_enabled=\"0\" border_width_all=\"0px\" border_radii_image=\"on|20px|20px|20px|20px\" box_shadow_style_image=\"preset3\" global_colors_info=\"{}\"][/et_pb_blog][/et_pb_column][et_pb_column type=\"2_3\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Post Slider</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_text _builder_version=\"4.16\" text_font=\"Arial||||||||\" text_font_size=\"16px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Latest Post</p>[/et_pb_text][et_pb_post_slider offset_number=\"0\" admin_label=\"Post Slider\" _builder_version=\"4.16\" hover_enabled=\"0\" border_radii_image=\"on|20px|20px|20px|20px\" box_shadow_style_image=\"preset3\" global_colors_info=\"{}\"][/et_pb_post_slider][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - Blog", "", "publish", "closed", "closed", "", "dmm-blog", "", "", "2021-12-22 08:18:04", "2021-12-22 08:18:04", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-blog/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("286", "8", "2021-12-22 08:18:11", "2021-12-22 08:18:11", "[et_pb_section fb_built=\"1\" _builder_version=\"4.16\" hover_enabled=\"0\" collapsed=\"off\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_4,1_4,1_4,1_4\" _builder_version=\"4.16\" custom_margin=\"||||true|true\" custom_padding=\"30px|50px|30px|50px|true|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Icon and description</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_blurb title=\"Element 1 \" url=\"#\" use_icon=\"on\" font_icon=\"&#xe08a;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>This in an example</p>[/et_pb_blurb][et_pb_blurb title=\"Element 2\" url=\"#\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>This in an example</p>[/et_pb_blurb][et_pb_blurb title=\"Element 3\" url=\"#\" use_icon=\"on\" font_icon=\"&#xe085;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>This in an example</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Title and description</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_blurb title=\"Element 1 \" url=\"#\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>This in an example</p>[/et_pb_blurb][et_pb_blurb title=\"Element 2\" url=\"#\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>This in an example</p>[/et_pb_blurb][et_pb_blurb title=\"Element 3\" url=\"#\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>This in an example</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Standart list with icon</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_blurb title=\"Element 1 \" url=\"#\" use_icon=\"on\" font_icon=\"&#xe08a;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Element 2\" url=\"#\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Element 3\" url=\"#\" use_icon=\"on\" font_icon=\"&#xe085;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Icon and description</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_blurb title=\"Element 1 \" url=\"#\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Element 2\" url=\"#\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Element 3\" url=\"#\" icon_placement=\"left\" _builder_version=\"4.16\" header_font=\"|600|||||||\" link_option_url=\"#\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - List", "", "publish", "closed", "closed", "", "dmm-list", "", "", "2021-12-22 08:18:11", "2021-12-22 08:18:11", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-list/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("287", "8", "2021-12-22 08:18:18", "2021-12-22 08:18:18", "[et_pb_section fb_built=\"1\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_3,1_3,1_3\" _builder_version=\"4.16\" custom_padding=\"40px|40px|40px|40px\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_3\" _builder_version=\"4.16\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Text block</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_blurb title=\"Phone\" use_icon=\"on\" font_icon=\"&#xe090;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>442181930</p>[/et_pb_blurb][et_pb_blurb title=\"Address\" use_icon=\"on\" font_icon=\"&#xe081;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>San Francisco, st #89</p>[/et_pb_blurb][et_pb_blurb title=\"Email\" use_icon=\"on\" font_icon=\"&#xe076;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>hola@diviengine.com</p>[/et_pb_blurb][et_pb_blurb title=\"Working hours\" use_icon=\"on\" font_icon=\"&#xe06b;||divi||400\" icon_color=\"#1d0d6f\" icon_placement=\"left\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Monday - Friday: 9 am - 8pm</p>\n<p>Saturday: 9am - 2pm</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Contact Form </p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_contact_form _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_contact_field field_id=\"Name\" field_title=\"Name\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\" button_text_size__hover_enabled=\"off\" button_one_text_size__hover_enabled=\"off\" button_two_text_size__hover_enabled=\"off\" button_text_color__hover_enabled=\"off\" button_one_text_color__hover_enabled=\"off\" button_two_text_color__hover_enabled=\"off\" button_border_width__hover_enabled=\"off\" button_one_border_width__hover_enabled=\"off\" button_two_border_width__hover_enabled=\"off\" button_border_color__hover_enabled=\"off\" button_one_border_color__hover_enabled=\"off\" button_two_border_color__hover_enabled=\"off\" button_border_radius__hover_enabled=\"off\" button_one_border_radius__hover_enabled=\"off\" button_two_border_radius__hover_enabled=\"off\" button_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover_enabled=\"off\" button_bg_color__hover_enabled=\"off\" button_one_bg_color__hover_enabled=\"off\" button_two_bg_color__hover_enabled=\"off\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Email\" field_title=\"Email Address\" field_type=\"email\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\" button_text_size__hover_enabled=\"off\" button_one_text_size__hover_enabled=\"off\" button_two_text_size__hover_enabled=\"off\" button_text_color__hover_enabled=\"off\" button_one_text_color__hover_enabled=\"off\" button_two_text_color__hover_enabled=\"off\" button_border_width__hover_enabled=\"off\" button_one_border_width__hover_enabled=\"off\" button_two_border_width__hover_enabled=\"off\" button_border_color__hover_enabled=\"off\" button_one_border_color__hover_enabled=\"off\" button_two_border_color__hover_enabled=\"off\" button_border_radius__hover_enabled=\"off\" button_one_border_radius__hover_enabled=\"off\" button_two_border_radius__hover_enabled=\"off\" button_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover_enabled=\"off\" button_bg_color__hover_enabled=\"off\" button_one_bg_color__hover_enabled=\"off\" button_two_bg_color__hover_enabled=\"off\"][/et_pb_contact_field][et_pb_contact_field field_id=\"Message\" field_title=\"Message\" field_type=\"text\" fullwidth_field=\"on\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\" button_text_size__hover_enabled=\"off\" button_one_text_size__hover_enabled=\"off\" button_two_text_size__hover_enabled=\"off\" button_text_color__hover_enabled=\"off\" button_one_text_color__hover_enabled=\"off\" button_two_text_color__hover_enabled=\"off\" button_border_width__hover_enabled=\"off\" button_one_border_width__hover_enabled=\"off\" button_two_border_width__hover_enabled=\"off\" button_border_color__hover_enabled=\"off\" button_one_border_color__hover_enabled=\"off\" button_two_border_color__hover_enabled=\"off\" button_border_radius__hover_enabled=\"off\" button_one_border_radius__hover_enabled=\"off\" button_two_border_radius__hover_enabled=\"off\" button_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover_enabled=\"off\" button_bg_color__hover_enabled=\"off\" button_one_bg_color__hover_enabled=\"off\" button_two_bg_color__hover_enabled=\"off\"][/et_pb_contact_field][/et_pb_contact_form][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.16\" text_font=\"Arial|600|||||||\" text_font_size=\"18px\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"]<p>Map</p>[/et_pb_text][et_pb_divider color=\"#0c71c3\" divider_weight=\"3px\" _builder_version=\"4.16\" width=\"20%\" module_alignment=\"left\" custom_margin=\"-10px||5px||false|false\" hover_enabled=\"0\" locked=\"off\" global_colors_info=\"{}\"][/et_pb_divider][et_pb_map address=\"London, UK\" zoom_level=\"12\" address_lat=\"51.50914020368143\" address_lng=\"-0.12787093998394994\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_map_pin title=\"london\" pin_address=\"London, UK\" pin_address_lat=\"51.5073509\" pin_address_lng=\"-0.12775829999998223\" _builder_version=\"3.0.98\" global_colors_info=\"{}\"][/et_pb_map_pin][/et_pb_map][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - Contact", "", "publish", "closed", "closed", "", "dmm-contact", "", "", "2021-12-22 08:18:18", "2021-12-22 08:18:18", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-contact/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("288", "8", "2021-12-22 08:18:26", "2021-12-22 08:18:26", "[et_pb_section fb_built=\"1\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_4,1_4,1_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_dmm_dropdown menu_id=\"7\" max_width_menu=\"300\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset1\" global_colors_info=\"{}\"][/et_pb_dmm_dropdown][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_dmm_dropdown menu_id=\"8\" max_width_menu=\"300\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset1\" global_colors_info=\"{}\"][/et_pb_dmm_dropdown][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_dmm_dropdown menu_id=\"9\" max_width_menu=\"300\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset1\" global_colors_info=\"{}\"][/et_pb_dmm_dropdown][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_dmm_dropdown menu_id=\"10\" max_width_menu=\"300\" menu_app_side=\"left\" _builder_version=\"4.16\" hover_enabled=\"0\" box_shadow_style=\"preset1\" global_colors_info=\"{}\"][/et_pb_dmm_dropdown][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - Drop Down", "", "publish", "closed", "closed", "", "dmm-drop-down", "", "", "2021-12-22 08:18:26", "2021-12-22 08:18:26", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-drop-down/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("289", "8", "2021-12-22 08:18:35", "2021-12-22 08:18:35", "[et_pb_section fb_built=\"1\" admin_label=\"section\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_row admin_label=\"row\" _builder_version=\"4.16\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.16\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_mm_tabs _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_tab title=\"Lorem ipsum dolor\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p><img class=\"alignleft wp-image-77 size-medium\" src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/feature-img-2-2-300x242-1.jpg\" alt=\"\" width=\"300\" height=\"242\" />Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n<p>Pharetra massa massa ultricies mi quis. Cursus risus at ultrices mi tempus. Donec adipiscing tristique risus nec feugiat in fermentum posuere urna. Odio eu feugiat pretium nibh ipsum consequat. Sed ullamcorper morbi tincidunt ornare massa eget egestas purus viverra. Habitant morbi tristique senectus et netus. </p>[/et_pb_tab][et_pb_tab title=\"Erat imperdiet sed\" _builder_version=\"4.16\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p><img class=\"wp-image-80 alignleft size-medium\" src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/feature-img-1-2-300x242-1.jpg\" alt=\"\" width=\"300\" height=\"242\" />Gravida dictum fusce ut placerat orci. In ornare quam viverra orci sagittis. Fermentum dui faucibus in ornare quam. Purus viverra accumsan in nisl nisi scelerisque eu ultrices. Non nisi est sit amet facilisis magna. Nunc consequat interdum varius sit amet. In ornare quam viverra orci sagittis eu. Id diam maecenas ultricies mi eget. Felis imperdiet proin fermentum leo vel orci porta non pulvinar. Praesent elementum facilisis leo vel fringilla est.</p>[/et_pb_tab][/et_pb_mm_tabs][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - Vertical Tabs", "", "publish", "closed", "closed", "", "dmm-vertical-tabs", "", "", "2021-12-22 08:18:35", "2021-12-22 08:18:35", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-vertical-tabs/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("290", "8", "2021-12-22 08:18:43", "2021-12-22 08:18:43", "[et_pb_section fb_built=\"1\" _builder_version=\"4.16\" inner_width_tablet=\"50px\" inner_max_width_tablet=\"100px\" inner_max_width_phone=\"50px\" custom_padding=\"0px|0px|0px|0px\" hover_enabled=\"0\" z_index_tablet=\"500\" border_radii=\"on|8px|8px|8px|8px\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" global_colors_info=\"{}\"][et_pb_row _builder_version=\"4.16\" width=\"100%\" max_width=\"2560px\" custom_padding=\"25px|25px|25px|25px\" hover_enabled=\"0\" z_index_tablet=\"500\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.16\" custom_padding=\"|||\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_blurb title=\"Divi All in One Theme\" image=\"http://localhost/divi-mega-menu/wp-content/uploads/2019/06/divi-logo.svg\" icon_placement=\"left\" _builder_version=\"4.16\" header_level=\"h3\" header_font=\"Lato|700||on|||||\" header_text_color=\"#8f42ec\" header_letter_spacing=\"1px\" body_font_size=\"13px\" animation=\"off\" link_option_url=\"#\" hover_enabled=\"0\" z_index_tablet=\"500\" header_text_shadow_horizontal_length_tablet=\"0px\" header_text_shadow_vertical_length_tablet=\"0px\" header_text_shadow_blur_strength_tablet=\"1px\" body_text_shadow_horizontal_length_tablet=\"0px\" body_text_shadow_vertical_length_tablet=\"0px\" body_text_shadow_blur_strength_tablet=\"1px\" body_link_text_shadow_horizontal_length_tablet=\"0px\" body_link_text_shadow_vertical_length_tablet=\"0px\" body_link_text_shadow_blur_strength_tablet=\"1px\" body_ul_text_shadow_horizontal_length_tablet=\"0px\" body_ul_text_shadow_vertical_length_tablet=\"0px\" body_ul_text_shadow_blur_strength_tablet=\"1px\" body_ol_text_shadow_horizontal_length_tablet=\"0px\" body_ol_text_shadow_vertical_length_tablet=\"0px\" body_ol_text_shadow_blur_strength_tablet=\"1px\" body_quote_text_shadow_horizontal_length_tablet=\"0px\" body_quote_text_shadow_vertical_length_tablet=\"0px\" body_quote_text_shadow_blur_strength_tablet=\"1px\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" box_shadow_horizontal_image_tablet=\"0px\" box_shadow_vertical_image_tablet=\"0px\" box_shadow_blur_image_tablet=\"40px\" box_shadow_spread_image_tablet=\"0px\" text_shadow_horizontal_length_tablet=\"0px\" text_shadow_vertical_length_tablet=\"0px\" text_shadow_blur_strength_tablet=\"1px\" global_colors_info=\"{}\"]<p>The Worlds #1 WordPress Theme &amp; Visual Page Builder</p>\r[/et_pb_blurb][et_pb_blurb title=\"Extra Magazine Theme\" image=\"http://localhost/divi-mega-menu/wp-content/uploads/2019/06/extra.svg\" icon_placement=\"left\" _builder_version=\"4.16\" header_level=\"h3\" header_font=\"Lato|700||on|||||\" header_text_color=\"#34dd87\" header_letter_spacing=\"1px\" body_font_size=\"13px\" animation=\"off\" link_option_url=\"#\" hover_enabled=\"0\" z_index_tablet=\"500\" header_text_shadow_horizontal_length_tablet=\"0px\" header_text_shadow_vertical_length_tablet=\"0px\" header_text_shadow_blur_strength_tablet=\"1px\" body_text_shadow_horizontal_length_tablet=\"0px\" body_text_shadow_vertical_length_tablet=\"0px\" body_text_shadow_blur_strength_tablet=\"1px\" body_link_text_shadow_horizontal_length_tablet=\"0px\" body_link_text_shadow_vertical_length_tablet=\"0px\" body_link_text_shadow_blur_strength_tablet=\"1px\" body_ul_text_shadow_horizontal_length_tablet=\"0px\" body_ul_text_shadow_vertical_length_tablet=\"0px\" body_ul_text_shadow_blur_strength_tablet=\"1px\" body_ol_text_shadow_horizontal_length_tablet=\"0px\" body_ol_text_shadow_vertical_length_tablet=\"0px\" body_ol_text_shadow_blur_strength_tablet=\"1px\" body_quote_text_shadow_horizontal_length_tablet=\"0px\" body_quote_text_shadow_vertical_length_tablet=\"0px\" body_quote_text_shadow_blur_strength_tablet=\"1px\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" box_shadow_horizontal_image_tablet=\"0px\" box_shadow_vertical_image_tablet=\"0px\" box_shadow_blur_image_tablet=\"40px\" box_shadow_spread_image_tablet=\"0px\" text_shadow_horizontal_length_tablet=\"0px\" text_shadow_vertical_length_tablet=\"0px\" text_shadow_blur_strength_tablet=\"1px\" global_colors_info=\"{}\"]<p>The perfect theme for bloggers and online-publications</p>\r[/et_pb_blurb][et_pb_blurb title=\"Divi Builder Plugin\" image=\"http://localhost/divi-mega-menu/wp-content/uploads/2019/06/divi-builder.svg\" icon_placement=\"left\" _builder_version=\"4.16\" header_level=\"h3\" header_font=\"Lato|700||on|||||\" header_text_color=\"#ff4a9e\" header_letter_spacing=\"1px\" body_font_size=\"13px\" animation=\"off\" link_option_url=\"#\" hover_enabled=\"0\" z_index_tablet=\"500\" header_text_shadow_horizontal_length_tablet=\"0px\" header_text_shadow_vertical_length_tablet=\"0px\" header_text_shadow_blur_strength_tablet=\"1px\" body_text_shadow_horizontal_length_tablet=\"0px\" body_text_shadow_vertical_length_tablet=\"0px\" body_text_shadow_blur_strength_tablet=\"1px\" body_link_text_shadow_horizontal_length_tablet=\"0px\" body_link_text_shadow_vertical_length_tablet=\"0px\" body_link_text_shadow_blur_strength_tablet=\"1px\" body_ul_text_shadow_horizontal_length_tablet=\"0px\" body_ul_text_shadow_vertical_length_tablet=\"0px\" body_ul_text_shadow_blur_strength_tablet=\"1px\" body_ol_text_shadow_horizontal_length_tablet=\"0px\" body_ol_text_shadow_vertical_length_tablet=\"0px\" body_ol_text_shadow_blur_strength_tablet=\"1px\" body_quote_text_shadow_horizontal_length_tablet=\"0px\" body_quote_text_shadow_vertical_length_tablet=\"0px\" body_quote_text_shadow_blur_strength_tablet=\"1px\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" box_shadow_horizontal_image_tablet=\"0px\" box_shadow_vertical_image_tablet=\"0px\" box_shadow_blur_image_tablet=\"40px\" box_shadow_spread_image_tablet=\"0px\" text_shadow_horizontal_length_tablet=\"0px\" text_shadow_vertical_length_tablet=\"0px\" text_shadow_blur_strength_tablet=\"1px\" global_colors_info=\"{}\"]<p>Harness the power of Divi with any WordPress theme.</p>\r[/et_pb_blurb][et_pb_blurb title=\"Bloom Email Optin Plugin\" image=\"http://localhost/divi-mega-menu/wp-content/uploads/2019/06/bloom.svg\" icon_placement=\"left\" _builder_version=\"4.16\" header_level=\"h3\" header_font=\"Lato|700||on|||||\" header_text_color=\"#4a42ec\" header_letter_spacing=\"1px\" body_font_size=\"13px\" animation=\"off\" link_option_url=\"#\" hover_enabled=\"0\" z_index_tablet=\"500\" header_text_shadow_horizontal_length_tablet=\"0px\" header_text_shadow_vertical_length_tablet=\"0px\" header_text_shadow_blur_strength_tablet=\"1px\" body_text_shadow_horizontal_length_tablet=\"0px\" body_text_shadow_vertical_length_tablet=\"0px\" body_text_shadow_blur_strength_tablet=\"1px\" body_link_text_shadow_horizontal_length_tablet=\"0px\" body_link_text_shadow_vertical_length_tablet=\"0px\" body_link_text_shadow_blur_strength_tablet=\"1px\" body_ul_text_shadow_horizontal_length_tablet=\"0px\" body_ul_text_shadow_vertical_length_tablet=\"0px\" body_ul_text_shadow_blur_strength_tablet=\"1px\" body_ol_text_shadow_horizontal_length_tablet=\"0px\" body_ol_text_shadow_vertical_length_tablet=\"0px\" body_ol_text_shadow_blur_strength_tablet=\"1px\" body_quote_text_shadow_horizontal_length_tablet=\"0px\" body_quote_text_shadow_vertical_length_tablet=\"0px\" body_quote_text_shadow_blur_strength_tablet=\"1px\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" box_shadow_horizontal_image_tablet=\"0px\" box_shadow_vertical_image_tablet=\"0px\" box_shadow_blur_image_tablet=\"40px\" box_shadow_spread_image_tablet=\"0px\" text_shadow_horizontal_length_tablet=\"0px\" text_shadow_vertical_length_tablet=\"0px\" text_shadow_blur_strength_tablet=\"1px\" global_colors_info=\"{}\"]<p>The ultimate email opt-in plugin for WordPress</p>\r[/et_pb_blurb][et_pb_blurb title=\"Monarch Social Media Plugin\" image=\"http://localhost/divi-mega-menu/wp-content/uploads/2019/06/monarch.svg\" icon_placement=\"left\" _builder_version=\"4.16\" header_level=\"h3\" header_font=\"Lato|700||on|||||\" header_text_color=\"#ff7b2b\" header_letter_spacing=\"1px\" body_font_size=\"13px\" animation=\"off\" link_option_url=\"#\" hover_enabled=\"0\" z_index_tablet=\"500\" header_text_shadow_horizontal_length_tablet=\"0px\" header_text_shadow_vertical_length_tablet=\"0px\" header_text_shadow_blur_strength_tablet=\"1px\" body_text_shadow_horizontal_length_tablet=\"0px\" body_text_shadow_vertical_length_tablet=\"0px\" body_text_shadow_blur_strength_tablet=\"1px\" body_link_text_shadow_horizontal_length_tablet=\"0px\" body_link_text_shadow_vertical_length_tablet=\"0px\" body_link_text_shadow_blur_strength_tablet=\"1px\" body_ul_text_shadow_horizontal_length_tablet=\"0px\" body_ul_text_shadow_vertical_length_tablet=\"0px\" body_ul_text_shadow_blur_strength_tablet=\"1px\" body_ol_text_shadow_horizontal_length_tablet=\"0px\" body_ol_text_shadow_vertical_length_tablet=\"0px\" body_ol_text_shadow_blur_strength_tablet=\"1px\" body_quote_text_shadow_horizontal_length_tablet=\"0px\" body_quote_text_shadow_vertical_length_tablet=\"0px\" body_quote_text_shadow_blur_strength_tablet=\"1px\" box_shadow_horizontal_tablet=\"0px\" box_shadow_vertical_tablet=\"0px\" box_shadow_blur_tablet=\"40px\" box_shadow_spread_tablet=\"0px\" box_shadow_horizontal_image_tablet=\"0px\" box_shadow_vertical_image_tablet=\"0px\" box_shadow_blur_image_tablet=\"40px\" box_shadow_spread_image_tablet=\"0px\" text_shadow_horizontal_length_tablet=\"0px\" text_shadow_vertical_length_tablet=\"0px\" text_shadow_blur_strength_tablet=\"1px\" global_colors_info=\"{}\"]<p>Built to get you more shares and more followers.</p>\r[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section]", "Mega Menú Business - Products", "", "publish", "closed", "closed", "", "dmm-products", "", "", "2021-12-22 08:18:43", "2021-12-22 08:18:43", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/dmm-products/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("895", "8", "2021-11-16 13:51:17", "2021-11-16 13:51:17", "[et_pb_section fb_built=\"1\" custom_padding_last_edited=\"on|desktop\" admin_label=\"Header\" _builder_version=\"4.16\" background_color_gradient_direction=\"130deg\" background_enable_image=\"off\" parallax=\"on\" custom_padding=\"0px||0px||true|false\" custom_padding_tablet=\"100px||100px||true\" custom_padding_phone=\"||||true\" bottom_divider_height=\"250px\" bottom_divider_flip=\"horizontal\" bottom_divider_height_tablet=\"150px\" bottom_divider_height_phone=\"110px\" bottom_divider_height_last_edited=\"on|phone\" hover_enabled=\"0\" saved_tabs=\"all\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_3,1_3,1_3\" make_equal=\"on\" _builder_version=\"4.16\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" custom_padding=\"0px||0px||true|\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" use_background_color_gradient=\"on\" background_color_gradient_direction=\"130deg\" background_color_gradient_stops=\"#8624E1 25%|#3607A6 100%\" background_color_gradient_start=\"#8624E1\" background_color_gradient_start_position=\"25%\" background_color_gradient_end=\"#3607A6\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/marketing-bg6.png\" custom_padding=\"50px|40px|20px|40px|false|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_image src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/laptop-analytics-2.png\" align=\"center\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"4.16\" custom_margin=\"||||false|false\" custom_margin_tablet=\"0vw|||\" custom_margin_phone=\"\" custom_margin_last_edited=\"on|tablet\" animation_style=\"roll\" animation_direction=\"left\" animation_intensity_roll=\"1%\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_image][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#FFFFFF\" text_font_size=\"20px\" text_line_height=\"1.4em\" text_orientation=\"center\" custom_margin=\"||10px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" text_orientation=\"center\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module.</p>[/et_pb_text][et_pb_button button_text=\"Click Here\" button_alignment=\"center\" _builder_version=\"4.16\" _module_preset=\"default\" custom_button=\"on\" button_text_color=\"#FFFFFF\" button_border_radius=\"36px\" button_font=\"Montserrat||||||||\" button_icon=\"&#x3d;||divi||400\" hover_enabled=\"0\" button_border_radius_tablet=\"\" button_border_radius_phone=\"\" button_border_radius_last_edited=\"on|desktop\" global_colors_info=\"{}\" button_border_radius__hover_enabled=\"on|desktop\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"50px||50px||true|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"||||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"50px||50px||true|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"||||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section]", "Agency Mega Menu - Services (Home Page)", "", "publish", "closed", "closed", "", "mm-bf1", "", "", "2021-11-16 13:51:17", "2021-11-16 13:51:17", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/mm-bf1/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("1733", "8", "2021-12-01 14:30:52", "2021-12-01 14:30:52", "[et_pb_section fb_built=\"1\" custom_padding_last_edited=\"on|desktop\" admin_label=\"Header\" _builder_version=\"4.16\" background_color_gradient_direction=\"130deg\" background_enable_image=\"off\" parallax=\"on\" custom_padding=\"0px||0px||true|false\" custom_padding_tablet=\"100px||100px||true\" custom_padding_phone=\"||||true\" bottom_divider_height=\"250px\" bottom_divider_flip=\"horizontal\" bottom_divider_height_tablet=\"150px\" bottom_divider_height_phone=\"110px\" bottom_divider_height_last_edited=\"on|phone\" hover_enabled=\"0\" saved_tabs=\"all\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_3,1_3,1_3\" make_equal=\"on\" _builder_version=\"4.16\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" custom_padding=\"0px||0px||true|\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" use_background_color_gradient=\"on\" background_color_gradient_direction=\"130deg\" background_color_gradient_stops=\"#8624E1 25%|#3607A6 100%\" background_color_gradient_start=\"#8624E1\" background_color_gradient_start_position=\"25%\" background_color_gradient_end=\"#3607A6\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/marketing-bg6.png\" custom_padding=\"50px|40px|20px|40px|false|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_image src=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/phones-diagonal-1.png\" title_text=\"phones-diagonal-1\" align=\"center\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"4.16\" custom_margin=\"||||false|false\" custom_margin_tablet=\"0vw|||\" custom_margin_phone=\"\" custom_margin_last_edited=\"on|tablet\" animation_style=\"roll\" animation_direction=\"left\" animation_intensity_roll=\"1%\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_image][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#FFFFFF\" text_font_size=\"20px\" text_line_height=\"1.4em\" text_orientation=\"center\" custom_margin=\"||10px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Get More Sales</p>[/et_pb_text][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" text_orientation=\"center\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module.</p>[/et_pb_text][et_pb_button button_text=\"Click Here\" button_alignment=\"center\" _builder_version=\"4.16\" _module_preset=\"default\" custom_button=\"on\" button_text_color=\"#FFFFFF\" button_border_radius=\"36px\" button_font=\"Montserrat||||||||\" button_icon=\"&#x3d;||divi||400\" hover_enabled=\"0\" button_border_radius_tablet=\"\" button_border_radius_phone=\"\" button_border_radius_last_edited=\"on|desktop\" global_colors_info=\"{}\" button_border_radius__hover_enabled=\"on|desktop\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"50px||50px||true|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"||||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00d;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#x76;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"50px||50px||true|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"||||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_blurb title=\"Your Title Goes Here\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_blurb][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"||||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe025;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe0ec;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe01d;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section]", "Agency Mega Menu - Category Page", "", "publish", "closed", "closed", "", "mm-web", "", "", "2021-12-01 14:30:52", "2021-12-01 14:30:52", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/mm-web/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("1735", "8", "2021-12-01 15:02:05", "2021-12-01 15:02:05", "[et_pb_section fb_built=\"1\" custom_padding_last_edited=\"on|desktop\" admin_label=\"Header\" _builder_version=\"4.16\" background_color_gradient_direction=\"130deg\" background_enable_image=\"off\" parallax=\"on\" custom_padding=\"0px||0px||true|false\" custom_padding_tablet=\"100px||100px||true\" custom_padding_phone=\"||||true\" bottom_divider_height=\"250px\" bottom_divider_flip=\"horizontal\" bottom_divider_height_tablet=\"150px\" bottom_divider_height_phone=\"110px\" bottom_divider_height_last_edited=\"on|phone\" hover_enabled=\"0\" saved_tabs=\"all\" global_colors_info=\"{}\"][et_pb_row column_structure=\"1_3,1_3,1_3\" make_equal=\"on\" _builder_version=\"4.16\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" custom_padding=\"0px||0px||true|\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" use_background_color_gradient=\"on\" background_color_gradient_direction=\"130deg\" background_color_gradient_stops=\"#8624E1 25%|#3607A6 100%\" background_color_gradient_start=\"#8624E1\" background_color_gradient_start_position=\"25%\" background_color_gradient_end=\"#3607A6\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/marketing-bg6.png\" custom_padding=\"50px|40px|50px|40px|true|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_video src=\"https://www.youtube.com/watch?v=FkQuawiGWUw\" _builder_version=\"4.16\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_video][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#FFFFFF\" text_font_size=\"20px\" text_line_height=\"1.4em\" text_orientation=\"center\" custom_margin=\"||10px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Get More Sales</p>[/et_pb_text][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" text_orientation=\"center\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. </p>[/et_pb_text][et_pb_button button_text=\"Click Here\" button_alignment=\"center\" _builder_version=\"4.16\" _module_preset=\"default\" custom_button=\"on\" button_text_color=\"#FFFFFF\" button_border_radius=\"36px\" button_font=\"Montserrat||||||||\" button_icon=\"&#x3d;||divi||400\" hover_enabled=\"0\" button_border_radius_tablet=\"\" button_border_radius_phone=\"\" button_border_radius_last_edited=\"on|desktop\" global_colors_info=\"{}\" button_border_radius__hover_enabled=\"on|desktop\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"50px||50px||true|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"||||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_blurb title=\"Facebook ADS\" use_icon=\"on\" font_icon=\"&#xe093;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" image_icon_width=\"45px\" content_max_width=\"100%\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#000000\" header_font_size=\"17px\" header_line_height=\"2.5em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px|||\" custom_padding=\"|0px|||false|false\" hover_enabled=\"0\" icon_font_size=\"45px\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Web Design \" use_icon=\"on\" font_icon=\"&#xe00d;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" image_icon_width=\"45px\" content_max_width=\"100%\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#000000\" header_font_size=\"17px\" header_line_height=\"2.5em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px|||\" custom_padding=\"|0px|||false|false\" hover_enabled=\"0\" icon_font_size=\"45px\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Social Media \" use_icon=\"on\" font_icon=\"&#xe094;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" image_icon_width=\"45px\" content_max_width=\"100%\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#000000\" header_font_size=\"17px\" header_line_height=\"2.5em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px|||\" custom_padding=\"|0px|||false|false\" hover_enabled=\"0\" icon_font_size=\"45px\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Google Business\" use_icon=\"on\" font_icon=\"&#xe0e3;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" image_icon_width=\"45px\" content_max_width=\"100%\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#000000\" header_font_size=\"17px\" header_line_height=\"2.5em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px|||\" custom_padding=\"|0px|||false|false\" hover_enabled=\"0\" icon_font_size=\"45px\" global_colors_info=\"{}\"][/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" background_color=\"rgba(0,0,0,0.05)\" custom_padding=\"50px||50px||true|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#000000\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"|30px||30px|false|true\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"|30px||30px|false|true\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][et_pb_button button_text=\"Click Here\" button_alignment=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" custom_button=\"on\" button_text_color=\"#FFFFFF\" button_bg_color=\"#8300E9\" button_border_color=\"#8300E9\" button_border_radius=\"0px\" button_font=\"Montserrat||||||||\" button_icon=\"&#x3d;||divi||400\" custom_margin=\"|||30px|false|false\" hover_enabled=\"0\" button_border_radius_tablet=\"\" button_border_radius_phone=\"\" button_border_radius_last_edited=\"on|desktop\" global_colors_info=\"{}\" button_border_radius__hover_enabled=\"on|desktop\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]", "Agency Mega Menu - Portfolio", "", "publish", "closed", "closed", "", "mm-portfolio", "", "", "2021-12-01 15:02:05", "2021-12-01 15:02:05", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/mm-portfolio/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("1738", "8", "2021-12-01 15:56:23", "2021-12-01 15:56:23", "[et_pb_section fb_built=\"1\" custom_padding_last_edited=\"on|desktop\" admin_label=\"Header\" _builder_version=\"4.16\" background_color_gradient_direction=\"130deg\" background_enable_image=\"off\" parallax=\"on\" custom_padding=\"0px||0px||true|false\" custom_padding_tablet=\"100px||100px||true\" custom_padding_phone=\"||||true\" bottom_divider_height=\"250px\" bottom_divider_flip=\"horizontal\" bottom_divider_height_tablet=\"150px\" bottom_divider_height_phone=\"110px\" bottom_divider_height_last_edited=\"on|phone\" hover_enabled=\"0\" saved_tabs=\"all\" global_colors_info=\"{}\"][et_pb_row column_structure=\"2_3,1_3\" _builder_version=\"4.16\" _module_preset=\"default\" use_background_color_gradient=\"on\" background_color_gradient_direction=\"130deg\" background_color_gradient_stops=\"#8624E1 25%|#3607A6 100%\" background_color_gradient_start=\"#8624E1\" background_color_gradient_start_position=\"25%\" background_color_gradient_end=\"#3607A6\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/marketing-bg6.png\" width=\"100%\" max_width=\"100%\" custom_padding=\"15px||15px||true|\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"2_3\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"6px||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.16\" _module_preset=\"default\" text_font=\"Montserrat|700|||||||\" text_text_color=\"#FFFFFF\" text_font_size=\"25px\" text_line_height=\"1.4em\" custom_margin=\"|||75px|false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"]<p>Best Marketing Services</p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"4.16\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_button button_text=\"Click Here\" _builder_version=\"4.16\" _module_preset=\"default\" custom_button=\"on\" button_text_color=\"#FFFFFF\" button_border_radius=\"36px\" button_font=\"Montserrat||||||||\" button_icon=\"&#x3d;||divi||400\" hover_enabled=\"0\" button_border_radius_tablet=\"\" button_border_radius_phone=\"\" button_border_radius_last_edited=\"on|desktop\" global_colors_info=\"{}\" button_border_radius__hover_enabled=\"on|desktop\"][/et_pb_button][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_4,1_4,1_4,1_4\" _builder_version=\"4.16\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" custom_padding=\"45px|70px|0px|70px|false|true\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_column type=\"1_4\" _builder_version=\"4.16\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#x76;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here. </p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#x76;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here. </p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\"][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" _module_preset=\"default\" custom_padding=\"||||false|false\" hover_enabled=\"0\" border_color_right=\"#8300E9\" global_colors_info=\"{}\"][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00d;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here.</p>[/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00d;||divi||400\" icon_color=\"#000000\" icon_placement=\"left\" image_icon_width=\"50px\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_text_color=\"#8300E9\" header_font_size=\"17px\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" hover_enabled=\"0\" icon_font_size=\"50px\" global_colors_info=\"{}\"]<p>Your content goes here.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" _module_preset=\"default\" hover_enabled=\"0\" border_color_left=\"#8300E9\" global_colors_info=\"{}\"][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe00b;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe025;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][et_pb_blurb title=\"Your Title Goes Here\" use_icon=\"on\" font_icon=\"&#xe0ec;||divi||400\" icon_color=\"#8300E9\" icon_placement=\"left\" _builder_version=\"4.16\" _module_preset=\"default\" header_font=\"Montserrat|600|||||||\" header_font_size=\"17px\" header_line_height=\"2em\" body_font=\"Montserrat||||||||\" body_font_size=\"12px\" custom_margin=\"||20px||false|false\" custom_padding=\"||||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\"][/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section]", "Agency Mega Menu - Web Projects", "", "publish", "closed", "closed", "", "mm-website-projects", "", "", "2021-12-01 15:56:23", "2021-12-01 15:56:23", "", "0", "http://cursopowerbi-dayde.es/et_pb_layout/mm-website-projects/", "0", "et_pb_layout", "", "0");
INSERT INTO `jx_posts` VALUES("1739", "8", "2023-09-20 09:48:49", "2023-09-20 07:48:49", "", "feature-img-2-2-300x242-1", "", "inherit", "open", "closed", "", "feature-img-2-2-300x242-1", "", "", "2023-09-20 09:48:49", "2023-09-20 07:48:49", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/feature-img-2-2-300x242-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `jx_posts` VALUES("1740", "8", "2023-09-20 09:48:50", "2023-09-20 07:48:50", "", "feature-img-1-2-300x242-1", "", "inherit", "open", "closed", "", "feature-img-1-2-300x242-1", "", "", "2023-09-20 09:48:50", "2023-09-20 07:48:50", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/feature-img-1-2-300x242-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `jx_posts` VALUES("1741", "8", "2023-09-20 09:48:50", "2023-09-20 07:48:50", "", "5", "", "inherit", "open", "closed", "", "5", "", "", "2023-09-20 09:48:50", "2023-09-20 07:48:50", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `jx_posts` VALUES("1742", "8", "2023-09-20 09:48:52", "2023-09-20 07:48:52", "", "geometric-bg-overlay-01", "", "inherit", "open", "closed", "", "geometric-bg-overlay-01", "", "", "2023-09-20 09:48:52", "2023-09-20 07:48:52", "", "0", "http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/geometric-bg-overlay-01.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `jx_posts` VALUES("1747", "8", "2023-11-20 15:54:20", "2023-11-20 14:54:20", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.23.1\" _module_preset=\"default\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\" da_disable_devices=\"off|off|off\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.23.1\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<div class=\"et_pb_module et_pb_text et_pb_text_24  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>Política de Privacidad</h2>\n</div>\n</div>\n<div class=\"et_pb_module et_pb_text et_pb_text_25  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h3>¿Quién es el responsable del tratamiento de sus datos?</h3>\n<p><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span></p>\n<p><span>B97743421</span></p>\n<h3>¿Con qué finalidad tratamos sus datos personales?</h3>\n<p>En<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>tratamos la información que nos facilitan las personas interesadas con el fin de Realizar la gestión administrativa, contable y fiscal de los servicios solicitados, así como enviar comunicaciones comerciales sobre nuestros productos y servicios.</p>\n<h3>¿Por cuánto tiempo conservaremos sus datos?</h3>\n<p>Los datos se conservarán mientras el interesado no solicite su supresión, y en su caso, durante los años necesarios para cumplir con las obligaciones legales.</p>\n<h3>¿Cuál es la legitimación para el tratamiento de sus datos?</h3>\n<p>Le indicamos la base legal para el tratamiento de sus datos:</p>\n<ul>\n<li>Interés legítimo del Responsable: Envío de comunicaciones comerciales</li>\n<li>Ejecución de un contrato: Prestación de los servicios solicitados</li>\n</ul>\n<h3>¿A qué destinatarios se comunicarán sus datos?</h3>\n<p>Los datos se comunicarán a los siguientes destinatarios:</p>\n<ul>\n<li>Entidades financieras, con la finalidad de Girar los recibos correspondientes</li>\n<li>Agencia Tributaria, con la finalidad de Cumplir con las obligaciones legales</li>\n</ul>\n<h3>Transferencias de datos a terceros países</h3>\n<p>No están previstas transferencias de datos a terceros países.</p>\n<h3>¿Cuáles son sus derechos cuando nos facilita sus datos?</h3>\n<p>Cualquier persona tiene derecho a obtener confirmación sobre si en<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>estamos tratando datos personales que les conciernan, o no.</p>\n<p>Las personas interesadas tienen derecho a acceder a sus datos personales, así como a solicitar la rectificación de los datos inexactos o, en su caso, solicitar su supresión cuando, entre otros motivos, los datos ya no sean necesarios para los fines que fueron recogidos.</p>\n<p>En determinadas circunstancias, los interesados podrán solicitar la limitación del tratamiento de sus datos, en cuyo caso únicamente los conservaremos para el ejercicio o la defensa de reclamaciones.</p>\n<p>En determinadas circunstancias y por motivos relacionados con su situación particular, los interesados podrán oponerse al tratamiento de sus datos. En este caso,<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>dejará de tratar los datos, salvo por motivos legítimos imperiosos, o el ejercicio o la defensa de posibles reclamaciones.</p>\n<p>Podrá ejercitar materialmente sus derechos de la siguiente forma: dirigiéndose a la dirección del responsable del tratamiento</p>\n<p>Si ha otorgado su consentimiento para alguna finalidad concreta, tiene derecho a retirar el consentimiento otorgado en cualquier momento, sin que ello afecte a la licitud del tratamiento basado en el consentimiento previo a su retirada.</p>\n<p>En caso de que sienta vulnerados sus derechos en lo concerniente a la protección de sus datos personales, especialmente cuando no haya obtenido satisfacción en el ejercicio de sus derechos, puede presentar una reclamación ante la Autoridad de Control en materia de Protección de Datos competente a través de su sitio web: <a href=\"http://www.agpd.es/\">www.agpd.es</a>.</p>\n<h3>¿Cómo hemos obtenido sus datos?</h3>\n<p>Los datos personales que tratamos en<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>proceden del propio interesado.</p>\n<p>Las categorías de datos que se tratan son:</p>\n<ul>\n<li>Datos identificativos</li>\n<li>Direcciones postales y electrónicas</li>\n<li>Información comercial</li>\n</ul>\n<p>No se tratan categorías especiales de datos personales (son aquellos datos que revelen el origen étnico o racial, las opiniones políticas, las convicciones religiosas o filosóficas, o la afiliación sindical, datos genéticos, datos biométricos dirigidos a identificar de manera unívoca a una persona física, datos relativos a la salud o datos relativos a la vida sexual o la orientación sexual de una persona física).</p>\n</div>\n</div>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Política de Privacidad", "", "publish", "closed", "closed", "", "politica-de-privacidad", "", "", "2023-11-20 15:55:52", "2023-11-20 14:55:52", "", "0", "http://cursopowerbi-dayde.es/?page_id=1747", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("1748", "8", "2023-11-20 15:54:20", "2023-11-20 14:54:20", "", "Política de Privacidad", "", "inherit", "closed", "closed", "", "1747-revision-v1", "", "", "2023-11-20 15:54:20", "2023-11-20 14:54:20", "", "1747", "http://cursopowerbi-dayde.es/?p=1748", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1749", "8", "2023-11-20 15:55:28", "2023-11-20 14:55:28", "[et_pb_section admin_label=\"section\"]\n			[et_pb_row admin_label=\"row\"]\n				[et_pb_column type=\"4_4\"][/et_pb_column]\n			[/et_pb_row]\n		[/et_pb_section]", "Política de Privacidad", "", "inherit", "closed", "closed", "", "1747-revision-v1", "", "", "2023-11-20 15:55:28", "2023-11-20 14:55:28", "", "1747", "http://cursopowerbi-dayde.es/?p=1749", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1750", "8", "2023-11-20 15:55:52", "2023-11-20 14:55:52", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.23.1\" _module_preset=\"default\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\" da_disable_devices=\"off|off|off\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.23.1\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<div class=\"et_pb_module et_pb_text et_pb_text_24  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>Política de Privacidad</h2>\n</div>\n</div>\n<div class=\"et_pb_module et_pb_text et_pb_text_25  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h3>¿Quién es el responsable del tratamiento de sus datos?</h3>\n<p><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span></p>\n<p><span>B97743421</span></p>\n<h3>¿Con qué finalidad tratamos sus datos personales?</h3>\n<p>En<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>tratamos la información que nos facilitan las personas interesadas con el fin de Realizar la gestión administrativa, contable y fiscal de los servicios solicitados, así como enviar comunicaciones comerciales sobre nuestros productos y servicios.</p>\n<h3>¿Por cuánto tiempo conservaremos sus datos?</h3>\n<p>Los datos se conservarán mientras el interesado no solicite su supresión, y en su caso, durante los años necesarios para cumplir con las obligaciones legales.</p>\n<h3>¿Cuál es la legitimación para el tratamiento de sus datos?</h3>\n<p>Le indicamos la base legal para el tratamiento de sus datos:</p>\n<ul>\n<li>Interés legítimo del Responsable: Envío de comunicaciones comerciales</li>\n<li>Ejecución de un contrato: Prestación de los servicios solicitados</li>\n</ul>\n<h3>¿A qué destinatarios se comunicarán sus datos?</h3>\n<p>Los datos se comunicarán a los siguientes destinatarios:</p>\n<ul>\n<li>Entidades financieras, con la finalidad de Girar los recibos correspondientes</li>\n<li>Agencia Tributaria, con la finalidad de Cumplir con las obligaciones legales</li>\n</ul>\n<h3>Transferencias de datos a terceros países</h3>\n<p>No están previstas transferencias de datos a terceros países.</p>\n<h3>¿Cuáles son sus derechos cuando nos facilita sus datos?</h3>\n<p>Cualquier persona tiene derecho a obtener confirmación sobre si en<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>estamos tratando datos personales que les conciernan, o no.</p>\n<p>Las personas interesadas tienen derecho a acceder a sus datos personales, así como a solicitar la rectificación de los datos inexactos o, en su caso, solicitar su supresión cuando, entre otros motivos, los datos ya no sean necesarios para los fines que fueron recogidos.</p>\n<p>En determinadas circunstancias, los interesados podrán solicitar la limitación del tratamiento de sus datos, en cuyo caso únicamente los conservaremos para el ejercicio o la defensa de reclamaciones.</p>\n<p>En determinadas circunstancias y por motivos relacionados con su situación particular, los interesados podrán oponerse al tratamiento de sus datos. En este caso,<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>dejará de tratar los datos, salvo por motivos legítimos imperiosos, o el ejercicio o la defensa de posibles reclamaciones.</p>\n<p>Podrá ejercitar materialmente sus derechos de la siguiente forma: dirigiéndose a la dirección del responsable del tratamiento</p>\n<p>Si ha otorgado su consentimiento para alguna finalidad concreta, tiene derecho a retirar el consentimiento otorgado en cualquier momento, sin que ello afecte a la licitud del tratamiento basado en el consentimiento previo a su retirada.</p>\n<p>En caso de que sienta vulnerados sus derechos en lo concerniente a la protección de sus datos personales, especialmente cuando no haya obtenido satisfacción en el ejercicio de sus derechos, puede presentar una reclamación ante la Autoridad de Control en materia de Protección de Datos competente a través de su sitio web: <a href=\"http://www.agpd.es/\">www.agpd.es</a>.</p>\n<h3>¿Cómo hemos obtenido sus datos?</h3>\n<p>Los datos personales que tratamos en<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>proceden del propio interesado.</p>\n<p>Las categorías de datos que se tratan son:</p>\n<ul>\n<li>Datos identificativos</li>\n<li>Direcciones postales y electrónicas</li>\n<li>Información comercial</li>\n</ul>\n<p>No se tratan categorías especiales de datos personales (son aquellos datos que revelen el origen étnico o racial, las opiniones políticas, las convicciones religiosas o filosóficas, o la afiliación sindical, datos genéticos, datos biométricos dirigidos a identificar de manera unívoca a una persona física, datos relativos a la salud o datos relativos a la vida sexual o la orientación sexual de una persona física).</p>\n</div>\n</div>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Política de Privacidad", "", "inherit", "closed", "closed", "", "1747-revision-v1", "", "", "2023-11-20 15:55:52", "2023-11-20 14:55:52", "", "1747", "http://cursopowerbi-dayde.es/?p=1750", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1751", "8", "2023-11-20 15:56:09", "2023-11-20 14:56:09", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.23.1\" _module_preset=\"default\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\" da_disable_devices=\"off|off|off\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.23.1\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<div class=\"et_pb_module et_pb_text et_pb_text_26  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>Aviso Legal</h2>\n</div>\n</div>\n<div class=\"et_pb_module et_pb_text et_pb_text_27  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>1. Objeto</h2>\n<p>El presente aviso legal regula el uso y utilización del sitio web https://imzortodoncia.com/<a href=\"https://angelessanchez.com/\"></a>, del que es titular<span> </span><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>(en adelante, EL PROPIETARIO DE LA WEB).</p>\n<p>La navegación por el sitio web de EL PROPIETARIO DE LA WEB le atribuye la condición de USUARIO del mismo y conlleva su aceptación plena y sin reservas de todas y cada una de las condiciones publicadas en este aviso legal, advirtiendo de que dichas condiciones podrán ser modificadas sin notificación previa por parte de EL PROPIETARIO DE LA WEB, en cuyo caso se procederá a su publicación y aviso con la máxima antelación posible.</p>\n<p>Por ello es recomendable leer atentamente su contenido en caso de desear acceder y hacer uso de la información y de los servicios ofrecidos desde este sitio web.</p>\n<p>El usuario además, se obliga a hacer un uso correcto del sitio web de conformidad con las leyes, la buena fe, el orden público, los usos del tráfico y el presente Aviso Legal, y responderá frente a EL PROPIETARIO DE LA WEB o frente a terceros, de cualesquiera daños y perjuicios que pudieran causarse como consecuencia del incumplimiento de dicha obligación.</p>\n<p>Cualquier utilización distinta a la autorizada está expresamente prohibida, pudiendo EL PROPIETARIO DE LA WEB denegar o retirar el acceso y su uso en cualquier momento.</p>\n<h2>2. Identificación</h2>\n<p>EL PROPIETARIO DE LA WEB, en cumplimiento de la Ley 34/2002, de 11 de julio, de Servicios de la Sociedad de la Información y de Comercio Electrónico, le informa de que:</p>\n<ul>\n<li>Su denominación social es:<span> </span><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span></li>\n<li>Su NIF es: B97743421</li>\n</ul>\n<h2>3. Comunicaciones</h2>\n<p>Para comunicarse con nosotros, ponemos a su disposición diferentes medios de contacto que detallamos a continuación:</p>\n<ul>\n<li>Email: ———-</li>\n</ul>\n<p>Todas las notificaciones y comunicaciones entre los usuarios y PROPIETARIO DE LA WEB se considerarán eficaces, a todos los efectos, cuando se realicen a través de cualquier medio de los detallados anteriormente.</p>\n<h2>4. Condiciones de acceso y utilización</h2>\n<p>El sitio web y sus servicios son de acceso libre y gratuito. No obstante, PROPIETARIO DE LA WEB puede condicionar la utilización de algunos de los servicios ofrecidos en su web a la previa cumplimentación del correspondiente formulario.</p>\n<p>El usuario garantiza la autenticidad y actualidad de todos aquellos datos que comunique a PROPIETARIO DE LA WEB y será el único responsable de las manifestaciones falsas o inexactas que realice.</p>\n<p>El usuario se compromete expresamente a hacer un uso adecuado de los contenidos y servicios de PROPIETARIO DE LA WEB y a no emplearlos para, entre otros:</p>\n<ol>\n<li>Difundir contenidos delictivos, violentos, pornográficos, racistas, xenófobos, ofensivos, de apología del terrorismo o, en general, contrarios a la ley o al orden público.</li>\n<li>Introducir en la red virus informáticos o realizar actuaciones susceptibles de alterar, estropear, interrumpir o generar errores o daños en los documentos electrónicos, datos o sistemas físicos y lógicos de PROPIETARIO DE LA WEB o de terceras personas; así como obstaculizar el acceso de otros usuarios al sitio web y a sus servicios mediante el consumo masivo de los recursos informáticos a través de los cuales PROPIETARIO DE LA WEB presta sus servicios.</li>\n<li>Intentar acceder a las cuentas de correo electrónico de otros usuarios o a áreas restringidas de los sistemas informáticos de PROPIETARIO DE LA WEB o de terceros y, en su caso, extraer información.</li>\n<li>Vulnerar los derechos de propiedad intelectual o industrial, así como violar la confidencialidad de la información de PROPIETARIO DE LA WEB o de terceros.</li>\n<li>Suplantar la identidad de cualquier otro usuario.</li>\n<li>Reproducir, copiar, distribuir, poner a disposición de, o cualquier otra forma de comunicación pública, transformar o modificar los contenidos, a menos que se cuente con la autorización del titular de los correspondientes derechos o ello resulte legalmente permitido.</li>\n<li>Recabar datos con finalidad publicitaria y de remitir publicidad de cualquier clase y comunicaciones con fines de venta u otras de naturaleza comercial sin que medie su previa solicitud o consentimiento.</li>\n</ol>\n<p>Todos los contenidos del sitio web, como textos, fotografías, gráficos, imágenes, iconos, tecnología, software, así como su diseño gráfico y códigos fuente, constituyen una obra cuya propiedad pertenece a PROPIETARIO DE LA WEB, sin que puedan entenderse cedidos al usuario ninguno de los derechos de explotación sobre los mismos más allá de lo estrictamente necesario para el correcto uso de la web.</p>\n<p>En definitiva, los usuarios que accedan a este sitio web pueden visualizar los contenidos y efectuar, en su caso, copias privadas autorizadas siempre que los elementos reproducidos no sean cedidos posteriormente a terceros, ni se instalen a servidores conectados a redes, ni sean objeto de ningún tipo de explotación.</p>\n<p>Asimismo, todas las marcas, nombres comerciales o signos distintivos de cualquier clase que aparecen en el sitio web son propiedad de PROPIETARIO DE LA WEB, sin que pueda entenderse que el uso o acceso al mismo atribuya al usuario derecho alguno sobre los mismos.</p>\n<p>La distribución, modificación, cesión o comunicación pública de los contenidos y cualquier otro acto que no haya sido expresamente autorizado por el titular de los derechos de explotación quedan prohibidos.</p>\n<p>El establecimiento de un hiperenlace no implica en ningún caso la existencia de relaciones entre PROPIETARIO DE LA WEB y el propietario del sitio web en la que se establezca, ni la aceptación y aprobación por parte de PROPIETARIO DE LA WEB de sus contenidos o servicios.</p>\n<p>PROPIETARIO DE LA WEB no se responsabiliza del uso que cada usuario le dé a los materiales puestos a disposición en este sitio web ni de las actuaciones que realice en base a los mismos.</p>\n<ul>\n<li>\n<h4>EXCLUSIÓN DE GARANTÍAS Y DE RESPONSABILIDAD EN EL ACCESO Y LA UTILIZACIÓN</h4>\n<p>El contenido del presente sitio web es de carácter general y tiene una finalidad meramente informativa, sin que se garantice plenamente el acceso a todos los contenidos, ni su exhaustividad, corrección, vigencia o actualidad, ni su idoneidad o utilidad para un objetivo específico.</p>\n<p>PROPIETARIO DE LA WEB excluye, hasta donde permite el ordenamiento jurídico, cualquier responsabilidad por los daños y perjuicios de toda naturaleza derivados de:</p>\n<ol>\n<li>a) La imposibilidad de acceso al sitio web o la falta de veracidad, exactitud, exhaustividad y/o actualidad de los contenidos, así como la existencia de vicios y defectos de toda clase de los contenidos transmitidos, difundidos, almacenados, puestos a disposición, a los que se haya accedido a través del sitio web o de los servicios que se ofrecen.</li>\n<li>b) La presencia de virus o de otros elementos en los contenidos que puedan producir alteraciones en los sistemas informáticos, documentos electrónicos o datos de los usuarios.</li>\n<li>c) El incumplimiento de las leyes, la buena fe, el orden público, los usos del tráfico y el presente aviso legal como consecuencia del uso incorrecto del sitio web. En particular, y a modo ejemplificativo, PROPIETARIO DE LA WEB no se hace responsable de las actuaciones de terceros que vulneren derechos de propiedad intelectual e industrial, secretos empresariales, derechos al honor, a la intimidad personal y familiar y a la propia imagen, así como la normativa en materia de competencia desleal y publicidad ilícita.</li>\n</ol>\n<p>Asimismo, PROPIETARIO DE LA WEB declina cualquier responsabilidad respecto a la información que se halle fuera de esta web y no sea gestionada directamente por nuestro webmaster. La función de los links que aparecen en esta web es exclusivamente la de informar al usuario sobre la existencia de otras fuentes susceptibles de ampliar los contenidos que ofrece este sitio web. PROPIETARIO DE LA WEB no garantiza ni se responsabiliza del funcionamiento o accesibilidad de los sitios enlazados; ni sugiere, invita o recomienda la visita a los mismos, por lo que tampoco será responsable del resultado obtenido. PROPIETARIO DE LA WEB no se responsabiliza del establecimiento de hipervínculos por parte de terceros.</p>\n</li>\n<li>\n<h4>PROCEDIMIENTO EN CASO DE REALIZACIÓN DE ACTIVIDADES DE CARÁCTER ILÍCITO</h4>\n<p>En el caso de que cualquier usuario o un tercero considere que existen hechos o circunstancias que revelen el carácter ilícito de la utilización de cualquier contenido y/o de la realización de cualquier actividad en las páginas web incluidas o accesibles a través del sitio web, deberá enviar una notificación a PROPIETARIO DE LA WEB identificándose debidamente y especificando las supuestas infracciones.</p>\n</li>\n</ul>\n<h4>PUBLICACIONES</h4>\n<p>La información administrativa facilitada a través del sitio web no sustituye la publicidad legal de las leyes, normativas, planes, disposiciones generales y actos que tengan que ser publicados formalmente a los diarios oficiales de las administraciones públicas, que constituyen el único instrumento que da fe de su autenticidad y contenido. La información disponible en este sitio web debe entenderse como una guía sin propósito de validez legal.</p>\n<h2>5. Legislación aplicable</h2>\n<p>Las condiciones presentes se regirán por la legislación española vigente.</p>\n<p>La lengua utilizada será el Castellano.</p>\n</div>\n</div>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Aviso Legal", "", "publish", "closed", "closed", "", "aviso-legal", "", "", "2023-11-20 15:56:43", "2023-11-20 14:56:43", "", "0", "http://cursopowerbi-dayde.es/?page_id=1751", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("1752", "8", "2023-11-20 15:56:09", "2023-11-20 14:56:09", "", "Aviso Legal", "", "inherit", "closed", "closed", "", "1751-revision-v1", "", "", "2023-11-20 15:56:09", "2023-11-20 14:56:09", "", "1751", "http://cursopowerbi-dayde.es/?p=1752", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1753", "8", "2023-11-20 15:56:25", "2023-11-20 14:56:25", "[et_pb_section admin_label=\"section\"]\n			[et_pb_row admin_label=\"row\"]\n				[et_pb_column type=\"4_4\"][/et_pb_column]\n			[/et_pb_row]\n		[/et_pb_section]", "Aviso Legal", "", "inherit", "closed", "closed", "", "1751-revision-v1", "", "", "2023-11-20 15:56:25", "2023-11-20 14:56:25", "", "1751", "http://cursopowerbi-dayde.es/?p=1753", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1754", "8", "2023-11-20 15:56:43", "2023-11-20 14:56:43", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.23.1\" _module_preset=\"default\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\" da_disable_devices=\"off|off|off\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.23.1\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<div class=\"et_pb_module et_pb_text et_pb_text_26  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>Aviso Legal</h2>\n</div>\n</div>\n<div class=\"et_pb_module et_pb_text et_pb_text_27  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>1. Objeto</h2>\n<p>El presente aviso legal regula el uso y utilización del sitio web https://imzortodoncia.com/<a href=\"https://angelessanchez.com/\"></a>, del que es titular<span> </span><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>(en adelante, EL PROPIETARIO DE LA WEB).</p>\n<p>La navegación por el sitio web de EL PROPIETARIO DE LA WEB le atribuye la condición de USUARIO del mismo y conlleva su aceptación plena y sin reservas de todas y cada una de las condiciones publicadas en este aviso legal, advirtiendo de que dichas condiciones podrán ser modificadas sin notificación previa por parte de EL PROPIETARIO DE LA WEB, en cuyo caso se procederá a su publicación y aviso con la máxima antelación posible.</p>\n<p>Por ello es recomendable leer atentamente su contenido en caso de desear acceder y hacer uso de la información y de los servicios ofrecidos desde este sitio web.</p>\n<p>El usuario además, se obliga a hacer un uso correcto del sitio web de conformidad con las leyes, la buena fe, el orden público, los usos del tráfico y el presente Aviso Legal, y responderá frente a EL PROPIETARIO DE LA WEB o frente a terceros, de cualesquiera daños y perjuicios que pudieran causarse como consecuencia del incumplimiento de dicha obligación.</p>\n<p>Cualquier utilización distinta a la autorizada está expresamente prohibida, pudiendo EL PROPIETARIO DE LA WEB denegar o retirar el acceso y su uso en cualquier momento.</p>\n<h2>2. Identificación</h2>\n<p>EL PROPIETARIO DE LA WEB, en cumplimiento de la Ley 34/2002, de 11 de julio, de Servicios de la Sociedad de la Información y de Comercio Electrónico, le informa de que:</p>\n<ul>\n<li>Su denominación social es:<span> </span><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span></li>\n<li>Su NIF es: B97743421</li>\n</ul>\n<h2>3. Comunicaciones</h2>\n<p>Para comunicarse con nosotros, ponemos a su disposición diferentes medios de contacto que detallamos a continuación:</p>\n<ul>\n<li>Email: ———-</li>\n</ul>\n<p>Todas las notificaciones y comunicaciones entre los usuarios y PROPIETARIO DE LA WEB se considerarán eficaces, a todos los efectos, cuando se realicen a través de cualquier medio de los detallados anteriormente.</p>\n<h2>4. Condiciones de acceso y utilización</h2>\n<p>El sitio web y sus servicios son de acceso libre y gratuito. No obstante, PROPIETARIO DE LA WEB puede condicionar la utilización de algunos de los servicios ofrecidos en su web a la previa cumplimentación del correspondiente formulario.</p>\n<p>El usuario garantiza la autenticidad y actualidad de todos aquellos datos que comunique a PROPIETARIO DE LA WEB y será el único responsable de las manifestaciones falsas o inexactas que realice.</p>\n<p>El usuario se compromete expresamente a hacer un uso adecuado de los contenidos y servicios de PROPIETARIO DE LA WEB y a no emplearlos para, entre otros:</p>\n<ol>\n<li>Difundir contenidos delictivos, violentos, pornográficos, racistas, xenófobos, ofensivos, de apología del terrorismo o, en general, contrarios a la ley o al orden público.</li>\n<li>Introducir en la red virus informáticos o realizar actuaciones susceptibles de alterar, estropear, interrumpir o generar errores o daños en los documentos electrónicos, datos o sistemas físicos y lógicos de PROPIETARIO DE LA WEB o de terceras personas; así como obstaculizar el acceso de otros usuarios al sitio web y a sus servicios mediante el consumo masivo de los recursos informáticos a través de los cuales PROPIETARIO DE LA WEB presta sus servicios.</li>\n<li>Intentar acceder a las cuentas de correo electrónico de otros usuarios o a áreas restringidas de los sistemas informáticos de PROPIETARIO DE LA WEB o de terceros y, en su caso, extraer información.</li>\n<li>Vulnerar los derechos de propiedad intelectual o industrial, así como violar la confidencialidad de la información de PROPIETARIO DE LA WEB o de terceros.</li>\n<li>Suplantar la identidad de cualquier otro usuario.</li>\n<li>Reproducir, copiar, distribuir, poner a disposición de, o cualquier otra forma de comunicación pública, transformar o modificar los contenidos, a menos que se cuente con la autorización del titular de los correspondientes derechos o ello resulte legalmente permitido.</li>\n<li>Recabar datos con finalidad publicitaria y de remitir publicidad de cualquier clase y comunicaciones con fines de venta u otras de naturaleza comercial sin que medie su previa solicitud o consentimiento.</li>\n</ol>\n<p>Todos los contenidos del sitio web, como textos, fotografías, gráficos, imágenes, iconos, tecnología, software, así como su diseño gráfico y códigos fuente, constituyen una obra cuya propiedad pertenece a PROPIETARIO DE LA WEB, sin que puedan entenderse cedidos al usuario ninguno de los derechos de explotación sobre los mismos más allá de lo estrictamente necesario para el correcto uso de la web.</p>\n<p>En definitiva, los usuarios que accedan a este sitio web pueden visualizar los contenidos y efectuar, en su caso, copias privadas autorizadas siempre que los elementos reproducidos no sean cedidos posteriormente a terceros, ni se instalen a servidores conectados a redes, ni sean objeto de ningún tipo de explotación.</p>\n<p>Asimismo, todas las marcas, nombres comerciales o signos distintivos de cualquier clase que aparecen en el sitio web son propiedad de PROPIETARIO DE LA WEB, sin que pueda entenderse que el uso o acceso al mismo atribuya al usuario derecho alguno sobre los mismos.</p>\n<p>La distribución, modificación, cesión o comunicación pública de los contenidos y cualquier otro acto que no haya sido expresamente autorizado por el titular de los derechos de explotación quedan prohibidos.</p>\n<p>El establecimiento de un hiperenlace no implica en ningún caso la existencia de relaciones entre PROPIETARIO DE LA WEB y el propietario del sitio web en la que se establezca, ni la aceptación y aprobación por parte de PROPIETARIO DE LA WEB de sus contenidos o servicios.</p>\n<p>PROPIETARIO DE LA WEB no se responsabiliza del uso que cada usuario le dé a los materiales puestos a disposición en este sitio web ni de las actuaciones que realice en base a los mismos.</p>\n<ul>\n<li>\n<h4>EXCLUSIÓN DE GARANTÍAS Y DE RESPONSABILIDAD EN EL ACCESO Y LA UTILIZACIÓN</h4>\n<p>El contenido del presente sitio web es de carácter general y tiene una finalidad meramente informativa, sin que se garantice plenamente el acceso a todos los contenidos, ni su exhaustividad, corrección, vigencia o actualidad, ni su idoneidad o utilidad para un objetivo específico.</p>\n<p>PROPIETARIO DE LA WEB excluye, hasta donde permite el ordenamiento jurídico, cualquier responsabilidad por los daños y perjuicios de toda naturaleza derivados de:</p>\n<ol>\n<li>a) La imposibilidad de acceso al sitio web o la falta de veracidad, exactitud, exhaustividad y/o actualidad de los contenidos, así como la existencia de vicios y defectos de toda clase de los contenidos transmitidos, difundidos, almacenados, puestos a disposición, a los que se haya accedido a través del sitio web o de los servicios que se ofrecen.</li>\n<li>b) La presencia de virus o de otros elementos en los contenidos que puedan producir alteraciones en los sistemas informáticos, documentos electrónicos o datos de los usuarios.</li>\n<li>c) El incumplimiento de las leyes, la buena fe, el orden público, los usos del tráfico y el presente aviso legal como consecuencia del uso incorrecto del sitio web. En particular, y a modo ejemplificativo, PROPIETARIO DE LA WEB no se hace responsable de las actuaciones de terceros que vulneren derechos de propiedad intelectual e industrial, secretos empresariales, derechos al honor, a la intimidad personal y familiar y a la propia imagen, así como la normativa en materia de competencia desleal y publicidad ilícita.</li>\n</ol>\n<p>Asimismo, PROPIETARIO DE LA WEB declina cualquier responsabilidad respecto a la información que se halle fuera de esta web y no sea gestionada directamente por nuestro webmaster. La función de los links que aparecen en esta web es exclusivamente la de informar al usuario sobre la existencia de otras fuentes susceptibles de ampliar los contenidos que ofrece este sitio web. PROPIETARIO DE LA WEB no garantiza ni se responsabiliza del funcionamiento o accesibilidad de los sitios enlazados; ni sugiere, invita o recomienda la visita a los mismos, por lo que tampoco será responsable del resultado obtenido. PROPIETARIO DE LA WEB no se responsabiliza del establecimiento de hipervínculos por parte de terceros.</p>\n</li>\n<li>\n<h4>PROCEDIMIENTO EN CASO DE REALIZACIÓN DE ACTIVIDADES DE CARÁCTER ILÍCITO</h4>\n<p>En el caso de que cualquier usuario o un tercero considere que existen hechos o circunstancias que revelen el carácter ilícito de la utilización de cualquier contenido y/o de la realización de cualquier actividad en las páginas web incluidas o accesibles a través del sitio web, deberá enviar una notificación a PROPIETARIO DE LA WEB identificándose debidamente y especificando las supuestas infracciones.</p>\n</li>\n</ul>\n<h4>PUBLICACIONES</h4>\n<p>La información administrativa facilitada a través del sitio web no sustituye la publicidad legal de las leyes, normativas, planes, disposiciones generales y actos que tengan que ser publicados formalmente a los diarios oficiales de las administraciones públicas, que constituyen el único instrumento que da fe de su autenticidad y contenido. La información disponible en este sitio web debe entenderse como una guía sin propósito de validez legal.</p>\n<h2>5. Legislación aplicable</h2>\n<p>Las condiciones presentes se regirán por la legislación española vigente.</p>\n<p>La lengua utilizada será el Castellano.</p>\n</div>\n</div>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Aviso Legal", "", "inherit", "closed", "closed", "", "1751-revision-v1", "", "", "2023-11-20 15:56:43", "2023-11-20 14:56:43", "", "1751", "http://cursopowerbi-dayde.es/?p=1754", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1755", "8", "2023-11-20 15:57:05", "2023-11-20 14:57:05", "[et_pb_section fb_built=\"1\" _builder_version=\"4.23.1\" _module_preset=\"default\" da_disable_devices=\"off|off|off\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"]<div class=\"et_pb_module et_pb_text et_pb_text_26  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<div class=\"et_pb_module et_pb_text et_pb_text_28  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>Política de Cookies</h2>\n</div>\n</div>\n<div class=\"et_pb_module et_pb_text et_pb_text_29  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<p>1.1.<span> </span><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span>, le informa que presente sitio web: https://imzortodoncia.com/ (en adelante, el “Sitio Web”) utiliza cookies que ayudan a optimizar su visita. Si continúa navegando en este Sitio Web, consideramos que acepta su uso.</p>\n<p>1.2. Una cookie es un fichero que se descarga en su ordenador al acceder a determinadas páginas web. Las cookies permiten a un sitio web, entre otras cosas, almacenar y recuperar información sobre los hábitos de navegación de un usuario o de su equipo y, dependiendo de la información que contengan y de la forma en que utilice su equipo, pueden utilizarse para reconocer al usuario.</p>\n<p>1.3.<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>tiene la obligación por el Real Decreto-ley 13/2012 que modifica la Ley 34/2002, de 11 de julio, de Servicios de la Sociedad de la Información y de Comercio Electrónico, de informar y obtener el consentimiento del usuario acerca del uso de las cookies en este Sitio Web.</p>\n<h3>Tipos de cookies<strong><br /></strong></h3>\n<p>2.1. Según quien sea la entidad que gestione el dominio desde donde se envían las cookies y trate los datos que se obtengan se pueden distinguir dos tipos: cookies propias y cookies de terceros.</p>\n<p>2.2. Existe también una segunda clasificación según el plazo de tiempo que permanecen almacenadas en el navegador del cliente, pudiendo tratarse de cookies de sesión o cookies persistentes.</p>\n<p>2.3. Por último, existe otra clasificación con cinco tipos de cookies según la finalidad para la que se traten los datos obtenidos: cookies técnicas, cookies de personalización, cookies de análisis, cookies publicitarias y cookies de publicidad comportamental.</p>\n<h3>Cookies utilizadas en este Sitio Web<strong><br /></strong></h3>\n<p>3.1.<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>utiliza las siguientes cookies analíticas:</p>\n<ul>\n<li>ac_cookies: cookie técnica y estrictamente necesaria que contiene el valor de si se ha aceptado la instalación de cookies. Caduca en 1 año desde la última actualización.</li>\n<li>_ga: cookie de Google Analytics que habilita la función de control de visitas únicas. La primera vez que un usuario entre en el sitio web a través de un navegador se instalará esta cookie. Cuando este usuario vuelva a entrar en la web con el mismo navegador, la cookie considerará que es el mismo usuario. Solo en el caso de que el usuario cambie de navegador, se considerará otro usuario. Caduca a los 2 años desde la última actualización.</li>\n<li>_gat: Esta cookie se asocia con Google Analytics Universal. Se utiliza para limitar la velocidad de petición – la limitación de la recogida de datos en los sitios de alto tráfico. Caduca a los 10 minutos.</li>\n<li>_utma: cookie de Google Analytics que registra la fecha de la primera y última vez que el usuario vistió el sitio web. Caduca a los 2 años desde la última actualización.</li>\n<li>_utmb: cookie de Google Analytics que registra la hora de llegada a la página web. Caduca a los 30 minutos desde la última actualización.</li>\n<li>_utmc: cookie de Google Analytics utilizada para la interoperabilidad con el código de seguimiento urchin.js. Se elimina al cerrar el navegador.</li>\n<li>_utmt: cookie de Google Analytics. Esta cookie se utiliza para procesar el tipo de solicitud pedida por el usuario. Caduca al finalizar la sesión.</li>\n<li>_utmv: cookie de Google Analytics. Esta cookie se utiliza para segmentar datos demográficos. Caduca al finalizar la sesión.</li>\n<li>_utmz: cookie de Google Analytics que almacena la fuente de tráfico o una campaña para explicar cómo el usuario llegó al sitio web. Caduca a los 6 meses desde la última actualización.</li>\n</ul>\n<p>Puede encontrar más información al respecto e inhabilitar el uso de estas cookies pulsando <a href=\"https://developers.google.com/analytics/devguides/collection/analyticsjs/cookie-usage?hl=es#analyticsjs\">aquí</a>.</p>\n<p>3.2. A través de la analítica web no se obtiene información sobre los datos personales de los usuarios, garantizando la tutela de su privacidad. La información que se obtiene es la relativa al número de usuarios que acceden a la web, el número de páginas vistas, la frecuencia y repetición de las visitas, su duración, el navegador utilizado, el operador que presta el servicio, el idioma, el terminal que utiliza, o la ciudad a la que está asignada su dirección IP. Información que posibilita un mejor y más apropiado servicio por parte de este Sitio Web.</p>\n<p>3.3.  Además de las cookies analíticas referidas en el punto 3.2, este Sitio Web utiliza cookies técnicas que permiten al usuario la navegación a través del Sitio Web y la utilización de las diferentes opciones o servicios que en él existen como, por ejemplo, controlar el tráfico y la comunicación de datos, identificar la sesión, o acceder a secciones de acceso restringido. Las cookies técnicas son las siguientes:</p>\n<p>AUTH_KEY</p>\n<p>SECURE_AUTH_KEY</p>\n<p>LOGGED_IN_KEY</p>\n<p>NONCE_KEY</p>\n<p>comment_author</p>\n<p>comment_author_email</p>\n<p>comment_author_url</p>\n<p>3.4. Al acceder el usuario a las páginas o perfiles de<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>en las distintas redes sociales acepta el uso de cookies por parte de las mismas.</p>\n<p>3.5. Dadas las características de Internet, no siempre contamos con información de las cookies que colocan terceras partes a través de este Sitio Web. Por consiguiente, en caso de que se encuentre con este tipo de cookies en este Sitio Web y no estén aquí descritas, le rogamos que nos lo comunique. También puede ponerse en contacto directamente con el tercero para pedirle información sobre las cookies que coloca, la finalidad y la duración de la cookie, y cómo garantiza la privacidad del usuario.</p>\n<h3>Modificar la configuración de las cookies<strong><br /></strong></h3>\n<p>4.1. El usuario puede permitir, bloquear o eliminar las cookies instaladas en su equipo mediante la configuración de las opciones del navegador instalado en su equipo.</p>\n<p>4.2. Para más información sobre Internet Explorer pulse <a href=\"http://windows.microsoft.com/es-xl/internet-explorer/delete-manage-cookies#ie=%22ie-10%22\">aquí</a>.</p>\n<p>4.3. Para más información sobre FireFox pulse <a href=\"http://support.mozilla.org/es/kb/Borrar%20cookies\">aquí</a>.</p>\n<p>4.4. Para más información sobre Chrome pulse <a href=\"http://support.google.com/chrome/answer/95647?hl=%22es%22\">aquí</a>.</p>\n<p>4.5. Para más información sobre Safari pulse <a href=\"https://support.apple.com/es-es/HT201265\">aquí</a>.</p>\n</div>\n</div>\n</div>\n</div>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Política de Cookies", "", "publish", "closed", "closed", "", "politica-de-cookies", "", "", "2023-11-20 15:57:37", "2023-11-20 14:57:37", "", "0", "http://cursopowerbi-dayde.es/?page_id=1755", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("1756", "8", "2023-11-20 15:57:05", "2023-11-20 14:57:05", "", "Política de Cookies", "", "inherit", "closed", "closed", "", "1755-revision-v1", "", "", "2023-11-20 15:57:05", "2023-11-20 14:57:05", "", "1755", "http://cursopowerbi-dayde.es/?p=1756", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1757", "8", "2023-11-20 15:57:11", "2023-11-20 14:57:11", "[et_pb_section admin_label=\"section\"]\n			[et_pb_row admin_label=\"row\"]\n				[et_pb_column type=\"4_4\"][/et_pb_column]\n			[/et_pb_row]\n		[/et_pb_section]", "Política de Cookies", "", "inherit", "closed", "closed", "", "1755-revision-v1", "", "", "2023-11-20 15:57:11", "2023-11-20 14:57:11", "", "1755", "http://cursopowerbi-dayde.es/?p=1757", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1758", "8", "2023-11-20 15:57:37", "2023-11-20 14:57:37", "[et_pb_section fb_built=\"1\" _builder_version=\"4.23.1\" _module_preset=\"default\" da_disable_devices=\"off|off|off\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"]<div class=\"et_pb_module et_pb_text et_pb_text_26  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<div class=\"et_pb_module et_pb_text et_pb_text_28  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<h2>Política de Cookies</h2>\n</div>\n</div>\n<div class=\"et_pb_module et_pb_text et_pb_text_29  et_pb_text_align_left et_pb_bg_layout_light\">\n<div class=\"et_pb_text_inner\">\n<p>1.1.<span> </span><span>CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span>, le informa que presente sitio web: https://imzortodoncia.com/ (en adelante, el “Sitio Web”) utiliza cookies que ayudan a optimizar su visita. Si continúa navegando en este Sitio Web, consideramos que acepta su uso.</p>\n<p>1.2. Una cookie es un fichero que se descarga en su ordenador al acceder a determinadas páginas web. Las cookies permiten a un sitio web, entre otras cosas, almacenar y recuperar información sobre los hábitos de navegación de un usuario o de su equipo y, dependiendo de la información que contengan y de la forma en que utilice su equipo, pueden utilizarse para reconocer al usuario.</p>\n<p>1.3.<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>tiene la obligación por el Real Decreto-ley 13/2012 que modifica la Ley 34/2002, de 11 de julio, de Servicios de la Sociedad de la Información y de Comercio Electrónico, de informar y obtener el consentimiento del usuario acerca del uso de las cookies en este Sitio Web.</p>\n<h3>Tipos de cookies<strong><br /></strong></h3>\n<p>2.1. Según quien sea la entidad que gestione el dominio desde donde se envían las cookies y trate los datos que se obtengan se pueden distinguir dos tipos: cookies propias y cookies de terceros.</p>\n<p>2.2. Existe también una segunda clasificación según el plazo de tiempo que permanecen almacenadas en el navegador del cliente, pudiendo tratarse de cookies de sesión o cookies persistentes.</p>\n<p>2.3. Por último, existe otra clasificación con cinco tipos de cookies según la finalidad para la que se traten los datos obtenidos: cookies técnicas, cookies de personalización, cookies de análisis, cookies publicitarias y cookies de publicidad comportamental.</p>\n<h3>Cookies utilizadas en este Sitio Web<strong><br /></strong></h3>\n<p>3.1.<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>utiliza las siguientes cookies analíticas:</p>\n<ul>\n<li>ac_cookies: cookie técnica y estrictamente necesaria que contiene el valor de si se ha aceptado la instalación de cookies. Caduca en 1 año desde la última actualización.</li>\n<li>_ga: cookie de Google Analytics que habilita la función de control de visitas únicas. La primera vez que un usuario entre en el sitio web a través de un navegador se instalará esta cookie. Cuando este usuario vuelva a entrar en la web con el mismo navegador, la cookie considerará que es el mismo usuario. Solo en el caso de que el usuario cambie de navegador, se considerará otro usuario. Caduca a los 2 años desde la última actualización.</li>\n<li>_gat: Esta cookie se asocia con Google Analytics Universal. Se utiliza para limitar la velocidad de petición – la limitación de la recogida de datos en los sitios de alto tráfico. Caduca a los 10 minutos.</li>\n<li>_utma: cookie de Google Analytics que registra la fecha de la primera y última vez que el usuario vistió el sitio web. Caduca a los 2 años desde la última actualización.</li>\n<li>_utmb: cookie de Google Analytics que registra la hora de llegada a la página web. Caduca a los 30 minutos desde la última actualización.</li>\n<li>_utmc: cookie de Google Analytics utilizada para la interoperabilidad con el código de seguimiento urchin.js. Se elimina al cerrar el navegador.</li>\n<li>_utmt: cookie de Google Analytics. Esta cookie se utiliza para procesar el tipo de solicitud pedida por el usuario. Caduca al finalizar la sesión.</li>\n<li>_utmv: cookie de Google Analytics. Esta cookie se utiliza para segmentar datos demográficos. Caduca al finalizar la sesión.</li>\n<li>_utmz: cookie de Google Analytics que almacena la fuente de tráfico o una campaña para explicar cómo el usuario llegó al sitio web. Caduca a los 6 meses desde la última actualización.</li>\n</ul>\n<p>Puede encontrar más información al respecto e inhabilitar el uso de estas cookies pulsando <a href=\"https://developers.google.com/analytics/devguides/collection/analyticsjs/cookie-usage?hl=es#analyticsjs\">aquí</a>.</p>\n<p>3.2. A través de la analítica web no se obtiene información sobre los datos personales de los usuarios, garantizando la tutela de su privacidad. La información que se obtiene es la relativa al número de usuarios que acceden a la web, el número de páginas vistas, la frecuencia y repetición de las visitas, su duración, el navegador utilizado, el operador que presta el servicio, el idioma, el terminal que utiliza, o la ciudad a la que está asignada su dirección IP. Información que posibilita un mejor y más apropiado servicio por parte de este Sitio Web.</p>\n<p>3.3.  Además de las cookies analíticas referidas en el punto 3.2, este Sitio Web utiliza cookies técnicas que permiten al usuario la navegación a través del Sitio Web y la utilización de las diferentes opciones o servicios que en él existen como, por ejemplo, controlar el tráfico y la comunicación de datos, identificar la sesión, o acceder a secciones de acceso restringido. Las cookies técnicas son las siguientes:</p>\n<p>AUTH_KEY</p>\n<p>SECURE_AUTH_KEY</p>\n<p>LOGGED_IN_KEY</p>\n<p>NONCE_KEY</p>\n<p>comment_author</p>\n<p>comment_author_email</p>\n<p>comment_author_url</p>\n<p>3.4. Al acceder el usuario a las páginas o perfiles de<span> CLÍNICA ZAHRAWI SALUD Y BELLEZA S.L.</span><span> </span>en las distintas redes sociales acepta el uso de cookies por parte de las mismas.</p>\n<p>3.5. Dadas las características de Internet, no siempre contamos con información de las cookies que colocan terceras partes a través de este Sitio Web. Por consiguiente, en caso de que se encuentre con este tipo de cookies en este Sitio Web y no estén aquí descritas, le rogamos que nos lo comunique. También puede ponerse en contacto directamente con el tercero para pedirle información sobre las cookies que coloca, la finalidad y la duración de la cookie, y cómo garantiza la privacidad del usuario.</p>\n<h3>Modificar la configuración de las cookies<strong><br /></strong></h3>\n<p>4.1. El usuario puede permitir, bloquear o eliminar las cookies instaladas en su equipo mediante la configuración de las opciones del navegador instalado en su equipo.</p>\n<p>4.2. Para más información sobre Internet Explorer pulse <a href=\"http://windows.microsoft.com/es-xl/internet-explorer/delete-manage-cookies#ie=%22ie-10%22\">aquí</a>.</p>\n<p>4.3. Para más información sobre FireFox pulse <a href=\"http://support.mozilla.org/es/kb/Borrar%20cookies\">aquí</a>.</p>\n<p>4.4. Para más información sobre Chrome pulse <a href=\"http://support.google.com/chrome/answer/95647?hl=%22es%22\">aquí</a>.</p>\n<p>4.5. Para más información sobre Safari pulse <a href=\"https://support.apple.com/es-es/HT201265\">aquí</a>.</p>\n</div>\n</div>\n</div>\n</div>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Política de Cookies", "", "inherit", "closed", "closed", "", "1755-revision-v1", "", "", "2023-11-20 15:57:37", "2023-11-20 14:57:37", "", "1755", "http://cursopowerbi-dayde.es/?p=1758", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1759", "8", "2023-11-20 15:59:04", "2023-11-20 14:59:04", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.23.1\" _module_preset=\"default\" title_text=\"geometric-bg-overlay-01\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/geometric-bg-overlay-01.jpg\" hover_enabled=\"0\" sticky_enabled=\"0\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\" da_disable_devices=\"off|off|off\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.23.1\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h1>Error 404. Página no encontrada.</h1>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "404", "", "publish", "closed", "closed", "", "404-2", "", "", "2023-11-20 15:59:04", "2023-11-20 14:59:04", "", "0", "http://cursopowerbi-dayde.es/?page_id=1759", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("1760", "8", "2023-11-20 15:58:04", "2023-11-20 14:58:04", "[et_pb_section admin_label=\"section\"]\n			[et_pb_row admin_label=\"row\"]\n				[et_pb_column type=\"4_4\"][/et_pb_column]\n			[/et_pb_row]\n		[/et_pb_section]", "404", "", "inherit", "closed", "closed", "", "1759-revision-v1", "", "", "2023-11-20 15:58:04", "2023-11-20 14:58:04", "", "1759", "http://cursopowerbi-dayde.es/?p=1760", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1761", "8", "2023-11-20 15:59:04", "2023-11-20 14:59:04", "[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.23.1\" _module_preset=\"default\" title_text=\"geometric-bg-overlay-01\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/geometric-bg-overlay-01.jpg\" hover_enabled=\"0\" sticky_enabled=\"0\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\" da_disable_devices=\"off|off|off\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column _builder_version=\"4.23.1\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h1>Error 404. Página no encontrada.</h1>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "404", "", "inherit", "closed", "closed", "", "1759-revision-v1", "", "", "2023-11-20 15:59:04", "2023-11-20 14:59:04", "", "1759", "http://cursopowerbi-dayde.es/?p=1761", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1762", "8", "2023-11-20 15:59:23", "2023-11-20 14:59:23", "[et_pb_section fb_built=\"1\" _builder_version=\"4.23.1\" _module_preset=\"default\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/geometric-bg-overlay-01.jpg\" da_disable_devices=\"off|off|off\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"]<h1>Gracias por ponerse en contacto con nosotros.</h1>\n<h2>Pronto nos comunicaremos con usted.</h2>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Gracias", "", "publish", "closed", "closed", "", "gracias", "", "", "2023-11-20 16:00:54", "2023-11-20 15:00:54", "", "0", "http://cursopowerbi-dayde.es/?page_id=1762", "0", "page", "", "0");
INSERT INTO `jx_posts` VALUES("1763", "8", "2023-11-20 15:59:23", "2023-11-20 14:59:23", "", "Gracias", "", "inherit", "closed", "closed", "", "1762-revision-v1", "", "", "2023-11-20 15:59:23", "2023-11-20 14:59:23", "", "1762", "http://cursopowerbi-dayde.es/?p=1763", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1764", "8", "2023-11-20 15:59:30", "2023-11-20 14:59:30", "[et_pb_section admin_label=\"section\"]\n			[et_pb_row admin_label=\"row\"]\n				[et_pb_column type=\"4_4\"][/et_pb_column]\n			[/et_pb_row]\n		[/et_pb_section]", "Gracias", "", "inherit", "closed", "closed", "", "1762-revision-v1", "", "", "2023-11-20 15:59:30", "2023-11-20 14:59:30", "", "1762", "http://cursopowerbi-dayde.es/?p=1764", "0", "revision", "", "0");
INSERT INTO `jx_posts` VALUES("1765", "8", "2023-11-20 16:00:54", "2023-11-20 15:00:54", "[et_pb_section fb_built=\"1\" _builder_version=\"4.23.1\" _module_preset=\"default\" background_image=\"http://cursopowerbi-dayde.es/wp-content/uploads/2023/09/geometric-bg-overlay-01.jpg\" da_disable_devices=\"off|off|off\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" da_is_popup=\"off\" da_exit_intent=\"off\" da_has_close=\"on\" da_alt_close=\"off\" da_dark_close=\"off\" da_not_modal=\"on\" da_is_singular=\"off\" da_with_loader=\"off\" da_has_shadow=\"on\"][et_pb_row _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.23.1\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.23.1\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"]<h1>Gracias por ponerse en contacto con nosotros.</h1>\n<h2>Pronto nos comunicaremos con usted.</h2>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]", "Gracias", "", "inherit", "closed", "closed", "", "1762-revision-v1", "", "", "2023-11-20 16:00:54", "2023-11-20 15:00:54", "", "1762", "http://cursopowerbi-dayde.es/?p=1765", "0", "revision", "", "0");

/* INSERT TABLE DATA: jx_term_relationships */
INSERT INTO `jx_term_relationships` VALUES("8", "2", "0");
INSERT INTO `jx_term_relationships` VALUES("283", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("283", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("283", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("284", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("284", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("284", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("285", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("285", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("285", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("286", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("286", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("286", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("287", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("287", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("287", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("288", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("288", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("288", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("289", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("289", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("289", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("290", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("290", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("290", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("895", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("895", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("895", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("1733", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("1733", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("1733", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("1735", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("1735", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("1735", "5", "0");
INSERT INTO `jx_term_relationships` VALUES("1738", "3", "0");
INSERT INTO `jx_term_relationships` VALUES("1738", "4", "0");
INSERT INTO `jx_term_relationships` VALUES("1738", "5", "0");

/* INSERT TABLE DATA: jx_term_taxonomy */
INSERT INTO `jx_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `jx_term_taxonomy` VALUES("2", "2", "wp_theme", "", "0", "1");
INSERT INTO `jx_term_taxonomy` VALUES("3", "3", "layout_type", "", "0", "12");
INSERT INTO `jx_term_taxonomy` VALUES("4", "4", "scope", "", "0", "12");
INSERT INTO `jx_term_taxonomy` VALUES("5", "5", "module_width", "", "0", "12");

/* INSERT TABLE DATA: jx_terms */
INSERT INTO `jx_terms` VALUES("1", "Noticias", "noticias", "0");
INSERT INTO `jx_terms` VALUES("2", "twentytwentythree", "twentytwentythree", "0");
INSERT INTO `jx_terms` VALUES("3", "layout", "layout", "0");
INSERT INTO `jx_terms` VALUES("4", "not_global", "not_global", "0");
INSERT INTO `jx_terms` VALUES("5", "regular", "regular", "0");

/* INSERT TABLE DATA: jx_usermeta */
INSERT INTO `jx_usermeta` VALUES("132", "8", "nickname", "root_alminora");
INSERT INTO `jx_usermeta` VALUES("133", "8", "first_name", "");
INSERT INTO `jx_usermeta` VALUES("134", "8", "last_name", "");
INSERT INTO `jx_usermeta` VALUES("135", "8", "description", "");
INSERT INTO `jx_usermeta` VALUES("136", "8", "rich_editing", "true");
INSERT INTO `jx_usermeta` VALUES("137", "8", "syntax_highlighting", "true");
INSERT INTO `jx_usermeta` VALUES("138", "8", "comment_shortcuts", "false");
INSERT INTO `jx_usermeta` VALUES("139", "8", "admin_color", "fresh");
INSERT INTO `jx_usermeta` VALUES("140", "8", "use_ssl", "0");
INSERT INTO `jx_usermeta` VALUES("141", "8", "show_admin_bar_front", "true");
INSERT INTO `jx_usermeta` VALUES("142", "8", "locale", "");
INSERT INTO `jx_usermeta` VALUES("143", "8", "jx_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `jx_usermeta` VALUES("144", "8", "jx_user_level", "10");
INSERT INTO `jx_usermeta` VALUES("145", "8", "dismissed_wp_pointers", "");
INSERT INTO `jx_usermeta` VALUES("147", "8", "jx_dashboard_quick_press_last_post_id", "1745");
INSERT INTO `jx_usermeta` VALUES("148", "8", "community-events-location", "a:1:{s:2:\"ip\";s:12:\"79.117.197.0\";}");
INSERT INTO `jx_usermeta` VALUES("151", "8", "_new_email", "a:2:{s:4:\"hash\";s:32:\"d4280a5e02d4a746318f3bb7947fcb8c\";s:8:\"newemail\";s:21:\"it@captabilidades.com\";}");
INSERT INTO `jx_usermeta` VALUES("154", "8", "rocket_boxes", "a:1:{i:0;s:34:\"rocket_warning_plugin_modification\";}");
INSERT INTO `jx_usermeta` VALUES("155", "8", "jx_user-settings", "imgsize=&libraryContent=browse");
INSERT INTO `jx_usermeta` VALUES("156", "8", "jx_user-settings-time", "1700492349");
INSERT INTO `jx_usermeta` VALUES("157", "8", "session_tokens", "a:1:{s:64:\"66e9b3c62b5de0b37ec68ab103427afd5cef74c126cb0243870f7f236e09e687\";a:4:{s:10:\"expiration\";i:1707403323;s:2:\"ip\";s:11:\"88.0.76.180\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36\";s:5:\"login\";i:1707230523;}}");

/* INSERT TABLE DATA: jx_users */
INSERT INTO `jx_users` VALUES("8", "root_alminora", "$P$By592K69C7UhuFsZ4YktuNeh8C9aWY.", "root_alminora", "dedalo.digital.wp@gmail.com", "", "2023-09-20 07:41:37", "", "0", "root_alminora");

/* INSERT TABLE DATA: jx_yoast_indexable */
INSERT INTO `jx_yoast_indexable` VALUES("8", "http://cursopowerbi-dayde.es/?page_id=14", "45:d9df736d6d52b11043785a13ee6aa5a1", "14", "post", "page", "1", "0", NULL, NULL, "Política de cookies", "trash", "0", "0", NULL, NULL, NULL, NULL, NULL, "0", "0", NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", "2023-03-23 10:36:29", "2023-03-16 15:41:05", NULL);
INSERT INTO `jx_yoast_indexable` VALUES("9", "http://cursopowerbi-dayde.es/?page_id=19", "45:da636a6ffe4e707bd44cf6bc11902a6a", "19", "post", "page", "1", "0", NULL, NULL, "Política de Privacidad", "trash", "0", "0", NULL, NULL, NULL, NULL, NULL, "0", "0", NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", "2023-03-23 10:36:29", "2023-03-16 15:42:54", NULL);
INSERT INTO `jx_yoast_indexable` VALUES("10", "http://cursopowerbi-dayde.es/?page_id=23", "45:22adacfc610bdfe374027333c644cf26", "23", "post", "page", "1", "0", NULL, NULL, "Aviso Legal", "trash", "0", "0", NULL, NULL, NULL, NULL, NULL, "0", "0", NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", "2023-03-23 10:36:29", "2023-03-16 15:43:36", NULL);
INSERT INTO `jx_yoast_indexable` VALUES("11", "http://cursopowerbi-dayde.es/?p=37", "39:5d9505c43745d8c8fc91bf3b7ccad6b2", "37", "post", "post", "7", "0", NULL, NULL, "Borrador automático", "trash", "0", "0", NULL, NULL, NULL, NULL, NULL, "0", "0", NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", "2023-09-20 07:42:12", "2023-09-20 07:42:12", NULL);
INSERT INTO `jx_yoast_indexable` VALUES("12", "http://cursopowerbi-dayde.es/noticias/noticias/", "52:6ba07c90a3a1bc8e2ee096b2216bc308", "1", "term", "category", NULL, NULL, NULL, NULL, "Noticias", NULL, NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", NULL, NULL, "2023-10-11 08:30:06", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", NULL, NULL, NULL);
INSERT INTO `jx_yoast_indexable` VALUES("13", NULL, NULL, NULL, "system-page", "404", NULL, NULL, "Page not found %%sep%% %%sitename%%", NULL, "Error 404: Page not found", NULL, NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", "1", "0", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2023-10-11 08:30:06", "1", NULL, NULL, NULL, NULL, "0", NULL, "1", NULL, NULL, NULL);
INSERT INTO `jx_yoast_indexable` VALUES("14", NULL, NULL, NULL, "system-page", "search-result", NULL, NULL, "You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%", NULL, NULL, NULL, NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", "1", "0", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2023-10-11 08:30:06", "1", NULL, NULL, NULL, NULL, "0", NULL, "1", NULL, NULL, NULL);
INSERT INTO `jx_yoast_indexable` VALUES("15", NULL, NULL, NULL, "date-archive", NULL, NULL, NULL, "%%date%% %%page%% %%sep%% %%sitename%%", "", NULL, NULL, "0", "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", "1", "0", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2023-10-11 08:30:06", "1", NULL, NULL, NULL, NULL, "0", NULL, "1", NULL, NULL, NULL);
INSERT INTO `jx_yoast_indexable` VALUES("16", "http://cursopowerbi-dayde.es/", "34:2587c649f63c410d03156bbf2754f707", NULL, "home-page", NULL, NULL, NULL, "%%sitename%% %%page%% %%sep%% %%sitedesc%%", "", "Home", NULL, NULL, "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", "1", "0", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, "%%sitename%%", "", "", "0", NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:06", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", NULL, NULL, NULL);
INSERT INTO `jx_yoast_indexable` VALUES("17", "http://cursopowerbi-dayde.es/brainaddons-popup/", "52:9179fb992dd3dd914fc1def6545d6dc9", NULL, "post-type-archive", "brainaddons-popup", NULL, NULL, "%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%", "", "Popups", NULL, "1", "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", "0", "0", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:07", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", NULL, NULL, NULL);
INSERT INTO `jx_yoast_indexable` VALUES("18", "http://cursopowerbi-dayde.es/project/", "42:2152fc85e409d7504897d9743ad845b4", NULL, "post-type-archive", "project", NULL, NULL, "%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%", "", "Proyectos", NULL, "1", "0", NULL, NULL, NULL, NULL, NULL, NULL, "0", "0", "0", "0", "0", "0", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "2023-10-11 08:30:07", "2024-02-06 15:38:58", "1", NULL, NULL, NULL, NULL, "0", NULL, "2", NULL, NULL, NULL);

/* INSERT TABLE DATA: jx_yoast_indexable_hierarchy */
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("1", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("2", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("3", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("4", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("5", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("6", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("7", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("8", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("9", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("10", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("11", "0", "0", "1");
INSERT INTO `jx_yoast_indexable_hierarchy` VALUES("12", "0", "0", "1");

/* INSERT TABLE DATA: jx_yoast_migrations */
INSERT INTO `jx_yoast_migrations` VALUES("1", "20171228151840");
INSERT INTO `jx_yoast_migrations` VALUES("2", "20171228151841");
INSERT INTO `jx_yoast_migrations` VALUES("3", "20190529075038");
INSERT INTO `jx_yoast_migrations` VALUES("4", "20191011111109");
INSERT INTO `jx_yoast_migrations` VALUES("5", "20200408101900");
INSERT INTO `jx_yoast_migrations` VALUES("6", "20200420073606");
INSERT INTO `jx_yoast_migrations` VALUES("7", "20200428123747");
INSERT INTO `jx_yoast_migrations` VALUES("8", "20200428194858");
INSERT INTO `jx_yoast_migrations` VALUES("9", "20200429105310");
INSERT INTO `jx_yoast_migrations` VALUES("10", "20200430075614");
INSERT INTO `jx_yoast_migrations` VALUES("11", "20200430150130");
INSERT INTO `jx_yoast_migrations` VALUES("12", "20200507054848");
INSERT INTO `jx_yoast_migrations` VALUES("13", "20200513133401");
INSERT INTO `jx_yoast_migrations` VALUES("14", "20200609154515");
INSERT INTO `jx_yoast_migrations` VALUES("15", "20200616130143");
INSERT INTO `jx_yoast_migrations` VALUES("16", "20200617122511");
INSERT INTO `jx_yoast_migrations` VALUES("17", "20200702141921");
INSERT INTO `jx_yoast_migrations` VALUES("18", "20200728095334");
INSERT INTO `jx_yoast_migrations` VALUES("19", "20201202144329");
INSERT INTO `jx_yoast_migrations` VALUES("20", "20201216124002");
INSERT INTO `jx_yoast_migrations` VALUES("21", "20201216141134");
INSERT INTO `jx_yoast_migrations` VALUES("22", "20210817092415");
INSERT INTO `jx_yoast_migrations` VALUES("23", "20211020091404");
INSERT INTO `jx_yoast_migrations` VALUES("24", "20190715101200");
INSERT INTO `jx_yoast_migrations` VALUES("25", "20210827093024");
INSERT INTO `jx_yoast_migrations` VALUES("26", "20230417083836");

SET FOREIGN_KEY_CHECKS = 1; 

/* Duplicator WordPress Timestamp: 2024-02-06 14:56:09*/
/* DUPLICATOR_MYSQLDUMP_EOF */
